% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_to_geojson.R
\name{dataframe_to_geojson}
\alias{dataframe_to_geojson}
\title{Concatenate a data.frame into a geojson polygon}
\usage{
dataframe_to_geojson(lonlat, dist = 1e-05, nQuadSegs = 2L, ...)
}
\arguments{
\item{lonlat}{a data.frame with geographical coordinates lonlat in 
that order}

\item{dist}{numeric, buffer distance for all \code{lonlat}}

\item{nQuadSegs}{integer, number of segments per quadrant}

\item{...}{further arguments passed to \code{\link[sf]{sf}} methods}
}
\value{
An object of class 'geojson' for each row in \code{lonlat}
}
\description{
Take single points from geographical coordinates and convert it into a
geojson 'Polygon' string using \code{\link[sf:geos_unary]{st_buffer}}.
}
\examples{
\donttest{
# random geographic points within bbox(10, 12, 45, 47)
library("sf")

set.seed(123)
lonlat <- data.frame(lon = runif(2, 10, 12),
                     lat = runif(2, 45, 47))

gjson <- dataframe_to_geojson(lonlat)
}
}
\seealso{
Other utility functions: 
\code{\link{sf_to_geojson}()}
}
\concept{utility functions}
