% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walking.R
\name{neighborhoodWalking}
\alias{neighborhoodWalking}
\title{Compute walking path pump neighborhoods.}
\usage{
neighborhoodWalking(pump.select = NULL, vestry = FALSE, weighted = TRUE,
  case.set = "observed", multi.core = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Default is NULL: all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}. Exclusion (negative selection) is possible (e.g., -6). Note that you can't just select the pump on Adam and Eve Court (#2): it's a technical isolate.}

\item{vestry}{Logical. TRUE uses the 14 pumps from the Vestry Report. FALSE uses the 13 in the original map.}

\item{weighted}{Logical. TRUE computes shortest path weighted by road length. FALSE computes shortest path in terms of the number of nodes.}

\item{case.set}{Character. "observed", "expected", or "snow". "snow" captures John Snow's annotation of the Broad Street pump neighborhood printed in the Vestry report version of the map.}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. You can also specify the number logical cores. On Window, only "multi.core = FALSE" is available.}
}
\value{
An R list with 7 objects:
\itemize{
  \item{\code{paths}: list of paths to nearest or selected pump(s).}
  \item{\code{cases}: list of cases by pump.}
  \item{\code{vestry}: "vestry" from neighborhoodWalking().}
  \item{\code{observed}: "observed" from neighborhoodWalking().}
  \item{\code{pump.select}: "pump.select" from neighborhoodWalking().}
  \item{\code{cores}: number of cores to use for parallel implementation.}
  \item{\code{metric}: incremental metric used to find cut point on split road segments.}
}
}
\description{
Group cases into neighborhoods based on walking distance.
}
\section{Note}{
 This function is computationally intensive. On a single core of a 2.3 GHz Intel i7, plotting observed paths takes about 8 seconds while plotting expected paths takes about 35 seconds. With the parallel implementation (currently only available on Linux and Mac and which the developer strongly discourages against using in a GUI or embedded environment), these times fall to 6 and 15 seconds using 4 physical (8 logical) cores.
}

\examples{
# neighborhoodWalking()
# neighborhoodWalking(pump.select = -6)
}
