% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voronoiPolygons.R
\name{voronoiPolygons}
\alias{voronoiPolygons}
\title{Extract vertices of Delaunay triangles and Dirichelet (Voronoi) tiles.}
\usage{
voronoiPolygons(sites, rw.data = NULL, rw = NULL, type = "tiles",
  output = "vertices")
}
\arguments{
\item{sites}{Object. Data frame of sites to compute Delaunay triangulation and Dirichelet (Voronoi) tessellation with variables "x" and "y".}

\item{rw.data}{Object. Data frame of secondary source of data to set the rectangular window or bounding box: observations, cases, etc. with variables "x" and "y".}

\item{rw}{Numeric. Alternative to rw.data: vector of corners to define the rectangular window or bounding box: xmin, xmax, ymin, ymax.}

\item{type}{Character. "tiles" (tessellation) or "triangles" (triangulation) vertices.}

\item{output}{Character. "vertices" or "polygons". "vertices" re "polygons" will draw base R polygons() to an existing plot.}
}
\value{
An R list of data frames or base R graphics polygon()'s'.
}
\description{
For construction and plotting of Delaunay and Voronoi polygons.
}
\note{
This function relies on the 'deldir' package.
}
\examples{
snowMap()
voronoiPolygons(pumps, output = "polygons")

snowMap()
voronoiPolygons(pumps, roads, output = "polygons")

snowMap()
voronoiPolygons(pumps, roads, type = "triangles", output = "polygons")

vertices <- voronoiPolygons(pumps, roads)
snow.colors <- grDevices::adjustcolor(snowColors(), alpha.f = 1/3)
snowMap(add.cases = FALSE)
invisible(lapply(seq_along(vertices), function(i) {
  polygon(vertices[[i]], col = snow.colors[[i]])
}))
}
