% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlongNearestPump.R
\name{latlongNearestPump}
\alias{latlongNearestPump}
\title{Compute shortest georeferenced distances (and walking paths) to selected pumps (prototype).}
\usage{
latlongNearestPump(pump.select = NULL, metric = "walking",
  vestry = FALSE, weighted = TRUE, time.unit = "second",
  walking.speed = 5, multi.core = TRUE)
}
\arguments{
\item{pump.select}{Numeric. Pump candidates to consider. Default is \code{NULL}: all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}. Negative selection allowed.}

\item{metric}{Character. "euclidean" or "walking".}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{weighted}{Logical. \code{TRUE} computes shortest path in terms of road length. \code{FALSE} computes shortest path in terms of the number of nodes.}

\item{time.unit}{Character. "hour", "minute", or "second".}

\item{walking.speed}{Numeric. Walking speed in km/hr.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. See \code{vignette("Parallelization")} for details.}
}
\value{
An R data frame or list of 'igraph' path nodes.
}
\description{
Compute shortest georeferenced distances (and walking paths) to selected pumps (prototype).
}
