% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{SpatialArray-class}
\alias{SpatialArray-class}
\alias{SpatialArray}
\title{Virtual Array of Vector Spatial data}
\arguments{
\item{stack}{A \code{SpatialStack} class object.}

\item{index}{A \code{vector}, \code{matrix} or \code{array} type object. Includes either the indices of layers in the stack, or their names.}

\item{dim}{A \code{numeric} vector. Same as for \code{array}, creates \code{proxy} procedurally.}
}
\value{
A \code{SpatialStack} class object.
}
\description{
Array template for Spatial object
}
\details{
The class implements structures to organize Spatial objects that have the same CRS. Subsetting rules were defined using the proxy object in the \code{index} slot. See examples for implementations.

The class has two slots:
stack: SpatialStack, the actual data.
index: A proxy object that represents the organization of the layers.
}
\examples{
# data import
  data(dems)
  st <-dems@stack
  ind <- 1:nlayers(st)
  names(ind) <- letters[1:length(ind)]
  ra<- RasterArray(stack=st, index=ind)
  
}
