% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ci_negbin.R
\name{add_ci.negbin}
\alias{add_ci.negbin}
\title{Confidence Intervals for Negative Binomial Linear Model Predictions}
\usage{
\method{add_ci}{negbin}(
  tb,
  fit,
  alpha = 0.05,
  names = NULL,
  yhatName = "pred",
  response = TRUE,
  type = "parametric",
  nSims = 2000,
  ...
)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{negbin}.}

\item{alpha}{A real number between 0 and 1. Controls the confidence
level of the interval estimates.}

\item{names}{\code{NULL} or character vector of length two. If
\code{NULL}, confidence bounds automatically will be named by
\code{add_ci}, otherwise, the lower confidence bound will be
named \code{names[1]} and the upper confidence bound will be
named \code{names[2]}.}

\item{yhatName}{A string. Name of the vector of predictions made
for each observation in tb}

\item{response}{A logical. The default is \code{TRUE}. If
\code{TRUE}, the confidence intervals will be determined for
the expected response; if \code{FALSE}, confidence intervals
will be made on the scale of the linear predictor.}

\item{type}{A string. Must be \code{type = "parametric"} or
\code{type = "boot"}. \code{type} determines the method used to
compute the confidence intervals.}

\item{nSims}{An integer. Number of simulations to perform if the
bootstrap method is used.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values, upper and lower
    confidence bounds attached.
}
\description{
This function is one of the methods for \code{add_ci}, and is
called automatically when \code{add_ci} is used on a \code{fit} of
class \code{negbin}.
}
\details{
The default link function is log-link. Confidence Intervals are
determined by making an interval on the scale of the linear
predictor, then applying the inverse link function from the model
fit to transform the linear level confidence intervals to the
response level. Alternatively, bootstrap confidence intervals may
be formed. The bootstrap intervals are formed by first resampling
cases from the data frame used to calculate \code{fit}, then bias
corrected and accelerated intervals are calculated. See
\code{boot::boot.ci} for more details.
}
\examples{
x1 <- rnorm(300, mean = 1)
y <- MASS::rnegbin(n = 300, mu = exp(5 + 0.5 * x1), theta = 2)
df <- data.frame(x1 = x1, y = y)
fit <- MASS::glm.nb(y ~ x1, data = df)
df <- df[sample(100),]
add_ci(df, fit, names = c("lcb", "ucb"))

}
\seealso{
\code{\link{add_pi.negbin}} for prediction intervals for
    \code{negbin} objects, \code{\link{add_probs.negbin}} for conditional
    probabilities of \code{negbin} objects, and
    \code{\link{add_quantile.negbin}} for response quantiles of
    \code{negbin} objects.
}
