% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_surf.R
\name{view_surf}
\alias{view_surf}
\title{View \code{"surf"} object(s)}
\usage{
view_surf(
  ...,
  view = c("both", "lateral", "medial"),
  width = NULL,
  height = NULL,
  zoom = NULL,
  bg = NULL,
  title = NULL,
  cex.title = NULL,
  text_color = "black",
  save = FALSE,
  close_after_save = TRUE,
  fname = "surf",
  alpha = 1,
  edge_color = NULL,
  vertex_color = NULL,
  vertex_size = 0,
  mode = NULL
)
}
\arguments{
\item{...}{One of: A \code{"surf"} object; two \code{"surf"} objects;
or, a \code{"xifti"} object. If a \code{"surf"} object has an empty
\code{"hemisphere"} metadata entry, it will be set to the opposite side 
of the other's if known; otherwise, it will be set to the left side. If both
are unknown, the first will be taken as the left and the second as the
right.}

\item{view}{Which view to display: \code{"lateral"}, \code{"medial"}, or 
\code{"both"}. If \code{NULL} (default), both views will be shown. Each view 
will be plotted in a separate panel row.}

\item{width}{The dimensions of the RGL window, in pixels. If both are
\code{NULL} (default), the dimensions will be set to
1000 (width) x 700 (height) for 1x1 and 2x2 subplots,
1500 x 525 for 2x1 subplots, and
500 x 700 for 1x2 subplots. These defaults are chosen to fit comfortably
within a 1600 x 900 screen. Specyfing only one will set the other to maintain
the same aspect ratio. Both can be specified to set the dimensions exactly.}

\item{height}{The dimensions of the RGL window, in pixels. If both are
\code{NULL} (default), the dimensions will be set to
1000 (width) x 700 (height) for 1x1 and 2x2 subplots,
1500 x 525 for 2x1 subplots, and
500 x 700 for 1x2 subplots. These defaults are chosen to fit comfortably
within a 1600 x 900 screen. Specyfing only one will set the other to maintain
the same aspect ratio. Both can be specified to set the dimensions exactly.}

\item{zoom}{Adjustment to size of brain meshes. Default: \code{3/5}
(100\% + 3/5*100\% = 160\% the original size).}

\item{bg}{Background color. \code{NULL} will not color the background (white).}

\item{title}{Optional title(s) for the plot(s). It will be printed at the top 
 in a separate subplot with 1/4 the height of the brain cortex subplots.
 
 Default: \code{NULL} will use the time index (".dtseries") or name
 (.dscalar or .dlabel) of the data column being plotted. 

 To use a custom title(s), use a length 1 character vector (same title for
 each plot) or length \code{length(idx)} character vector (different title
 for each plot). Set to an empty string \code{""} to omit the title. 

 If the title is non-empty but does not appear, \code{cex.title} may need to 
 be lowered.}

\item{cex.title}{Font size multiplier for the title. \code{NULL} (default)
will use \code{2} for titles less than 20 characters long, and smaller
sizes for increasingly longer titles.}

\item{text_color}{Color for text in title and colorbar legend. Default:
"black".}

\item{save}{Save the plot to a .png file named by \code{fname}? Default:
\code{FALSE}.}

\item{close_after_save}{If \code{save==TRUE}, close the interactive Open GL 
window at the end of this function call? Default: \code{TRUE}.}

\item{fname}{An identifier to use for naming the saved images
("[fname].png") or video frames ("[fname]_1.png", "[fname]_2.png", ...).
Default: \code{"xifti"} for \code{xifti_view_surface} and \code{"surf"} for
\code{view_surf}.}

\item{alpha}{Transparency value for mesh coloring, between 0 and 1. Default:
\code{1.0} (no transparency).}

\item{edge_color}{Outline each edge in this color. Default: \code{NULL} (do
not outline the edges).}

\item{vertex_color}{Draw each vertex in this color. Default: 
\code{"black"}. Vertices are only drawn if \code{vertex_size > 0}}

\item{vertex_size}{Draw each vertex with this size. Default: \code{0} 
(do not draw the vertices).}

\item{mode}{Deprecated: has no effect and will be removed. See \code{save}
and \code{close_after_save}.}
}
\description{
Visualize one or two \code{"surf"} objects(s), or the \code{"surf"} 
 component(s) in a \code{"xifti"} using an interactive Open GL window
 made with \code{rgl}. The \code{rgl} package is required.
}
\details{
This function works as a wrapper to \code{\link{view_xifti_surface}}, but 
 some arguments are not applicable (e.g. color scheme and legend). Also, 
 instead of using the \code{hemisphere} argument, name the surface arguments
 \code{surfL} or \code{surfR} (see description for parameter \code{...}).
 Finally, the default value for \code{param} is \code{"surf"}, not 
 \code{"xifti"}.
}
\section{Navigating and Embedding the Interactive Plots}{

 This function opens an interactive Open GL window rendered by \code{rgl}. 
 If \code{save==TRUE} and \code{close_after_save==TRUE}, the window will be
 closed after the function call. Otherwise, it is kept open and the following
 information applies:

 To navigate the plot, left click and drag the cursor to rotate. Use the 
 scroll wheel or right click and drag to zoom. Press the scroll wheel and drag
 to change the field-of-view. Execute \code{\link[rgl]{snapshot}} to save the
 current window as a .png file. Execute \code{\link[rgl:rgl.open]{rgl.close}} to close
 the window. \code{\link[rgl:viewpoint]{rgl.viewpoint}} can be used for programmatic
 navigation. 

 The Open GL window can be embedded as an htmlwidget in an R Markdown document
 using one of two methods. The first is executing \code{\link[rgl]{rglwidget}}
 in the chunk where the plot is made. This first method should work within
 both the RStudio IDE and a knitted .html file. The second method is 
 executing \code{\link[rgl:hook_rgl]{setupKnitr}} at the start of the document and 
 then using the chunk option \code{webgl=TRUE} in the chunk where the plot is
 made. The second method is specifically for knitted .html files. Although
 the first method is the newest approach and is recommended by others, we
 used the second method in the \code{ciftiTools} vignette because the first
 is not compatible with htmlpreview. For both methods, the window still
 needs to be open to render the widget. Also for both methods, you will 
 probably need to tweak the image dimensions e.g. 
 \code{fig.width=8, fig.height=5} in the chunk options, because it uses the 
 defaults from RMarkdown/Knitr instead of what makes sense based on the 
 dimensions of the Open GL window.
 
 For \code{view_xifti_surface}, if \code{length(idx) > 1}, this function will
 automaticaly return an htmlwidget using the first method, but with a
 \code{\link[rgl]{playwidget}} wrapper to add a slider to control which
 column index is being displayed. All the meshes will be rendered on top of
 one another in the Open GL window, so only the widget will be useful for
 viewing the data interactively. Since it uses the first method, it will not
 be visible with htmlpreview. No additional call to 
 \code{\link[rgl]{rglwidget}} is necessary, but \code{\link[rgl:rgl.open]{rgl.close}}
 must be called in a following chunk to close the Open GL window.
}

\section{Embedding the Static Plots}{

 If \code{save==TRUE}, the plot(s) is written to a .png file. (For 
 \code{view_xifti_surface}, if \code{length(idx) > 1}, each \code{idx} will
 be written to a separate image file.) You can use 
 \code{\link[knitr]{include_graphics}} to embed an image file in an R
 Markdown document. If \code{close_after_save==TRUE}, the return value of this
 function call is the name(s) of the image file(s) that were written, so it
 can be used directly to display the image.

 There's an additional way to embed an image of this plot without writing a
 .png file: use \code{save==FALSE} and set the chunk options 
 \code{rgl=TRUE, format="png"}. You will probably need to tweak the image
 dimensions e.g. \code{fig.width=8, fig.height=5} in the chunk options, 
 because it uses the defaults from RMarkdown/Knitr instead of what makes
 sense based on the dimensions of the Open GL window.
}

