% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cifti_convert.R
\name{read_cifti_convert}
\alias{read_cifti_convert}
\title{Read a CIFTI file quickly}
\usage{
read_cifti_convert(
  cifti_fname,
  surfL_fname = NULL,
  surfR_fname = NULL,
  brainstructures = c("left", "right"),
  idx = NULL,
  mwall_values = c(NA, NaN),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{cifti_fname}{File path to a CIFTI file (ending in ".d*.nii").}

\item{surfL_fname}{(Optional) File path to a GIFTI surface geometry
file representing the left cortex.}

\item{surfR_fname}{(Optional) File path to a GIFTI surface geometry
file representing the right cortex.}

\item{brainstructures}{Character vector indicating which brain structure(s)
to obtain: \code{"left"} (left cortex), \code{"right"} (right cortex)
and/or \code{"subcortical"} (subcortex and cerebellum). Can also be
\code{"all"} (obtain all three brain structures). Default:
\code{c("left","right")} (cortex only).

If a brain structure is indicated but does not exist in the CIFTI file, a
warning will occur and that brain structure will be skipped.}

\item{idx}{Numeric vector indicating the data indices (columns) to read. If
\code{NULL} (default), read in all the data. Must be a subset of the indices
present in the file, or an error will occur.

For high-resolution CIFTI files, reading in only a subset of the data saves
memory, but will be slower than reading in the entire file due to the
required intermediate steps.}

\item{mwall_values}{If the medial wall mask is not present in the CIFTI,
infer it from these data values. Default: \code{c(NA, NaN)}. If \code{NULL},
do not attempt to infer the medial wall mask from the data values.}

\item{verbose}{Should occasional updates be printed? Default: \code{FALSE}.}

\item{...}{Additional arguments to \code{read_cifti_flat}.}
}
\value{
A \code{"xifti"} object. See \code{\link{is.xifti}}.
}
\description{
Read a CIFTI file by exporting it as a single GIFTI
using \code{-cifti-convert -to-gifti-ext} (\code{\link{read_cifti_flat}}),
and obtaining the brainordinate mapping using
\code{-cifti-export-dense-mapping} (\code{\link{info_cifti}}).
}
\keyword{internal}
