% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_cifti.R
\name{separate_cifti_files}
\alias{separate_cifti_files}
\title{Separate CIFTI: file names}
\usage{
separate_cifti_files(
  bs_present,
  intent = 3006,
  brainstructures = NULL,
  cortexL_fname = NULL,
  cortexR_fname = NULL,
  subcortVol_fname = NULL,
  subcortLabs_fname = NULL,
  ROI_brainstructures = "all",
  ROIcortexL_fname = NULL,
  ROIcortexR_fname = NULL,
  ROIsubcortVol_fname = NULL,
  write_dir = NULL
)
}
\arguments{
\item{bs_present}{The brain structures actually present in the CIFTI or
\code{"xifti"} object.}

\item{intent}{3002 (default), 3006, or 3007}

\item{brainstructures}{(Optional) character vector indicating a subset of
brain structure(s) to write: \code{"left"} cortex, \code{"right"} cortex,
and/or \code{"subcortical"} structures. Can also be \code{"all"} to write
out all existing brain structures. Default: \code{c("left","right")}.}

\item{cortexL_fname, cortexR_fname}{(Optional) GIFTI file names
(*.[func/label].gii) to save the [left/right] cortex data to.
dtseries and dscalar files should use "func", whereas dlabel files should
use "label".

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*[L/R].\[func/label\].gii"}, where * is the file name component of
\code{cifti_fname}.}

\item{subcortVol_fname, subcortLabs_fname}{(Optional) NIFTI file names to save
the subcortical [volume/labels] to. Provide both or neither.

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*[/.labels].nii"}, where * is the file name component of
\code{cifti_fname}.}

\item{ROI_brainstructures}{Which ROIs should be obtained? \code{"all"}
(default) to obtain ROIs for each of the \code{brainstructures}. \code{NULL}
to not obtain any ROIs. This should be a subset of \code{brainstructures}.}

\item{ROIcortexL_fname, ROIcortexR_fname}{(Optional) GIFTI file names
(*.[func/label].gii) to save the [left/right] cortex ROI to.
dtseries and dscalar files should use "func", whereas dlabel files should
use "label".

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*ROI_[L/R].\[func/label\].gii"}, where * is the file name component of
\code{cifti_fname}.

The cortical ROIs typically represent the medial wall
mask, with values of 1 for in-ROI (non-medial wall) vertices and 0 for
out-of-ROI (medial wall) vertices. Will be written in \code{write_dir}.}

\item{ROIsubcortVol_fname}{(Optional) NIFTI file names to save
the subcortical ROI to.

If \code{NULL} and \code{write_dir} is provided, defaults to
\code{"*ROI.nii"}, where * is the file name component of
\code{cifti_fname}.

The subcortical ROI typically represents the volumetric
mask for the entire subcortical structure, with values of 1 for in-ROI
(in subcortex) voxels and 0 for out-of-ROI (not in subcortex) voxels. Will
be written in \code{write_dir}.}

\item{write_dir}{(Optional) A path to an existing directory. If provided,
every component in the \code{"xifti"} will be written to this directory,
using automatically-generated names if their \code{*_fname} argument was
not provided. Otherwise if \code{write_dir} is \code{NULL}, only the
components for which their \code{*_fname} was provided will be written.}
}
\value{
List of three: \code{do}, \code{ROI_do}, and \code{sep_fnames}
}
\description{
File paths for writing GIFTI and NIFTI files from a CIFTI or \code{"xifti"}
}
\details{
If \code{write_dir} is \code{NULL}, only components with provided file names
will be written. If \code{write_dir} is not \code{NULL}, files for all
existing brain components will be written to that directory.
}
\keyword{internal}
