% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remap_cifti.R
\name{remap_cifti}
\alias{remap_cifti}
\alias{remapCIfTI}
\alias{remapcii}
\alias{remap_xifti}
\title{Remap CIFTI data}
\usage{
remap_cifti(
  x,
  cifti_target_fname = NULL,
  remap_method = c("adaptive", "barycentric"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  areaL_target_fname = NULL,
  areaR_target_fname = NULL,
  sphereL_original_fname = NULL,
  sphereR_original_fname = NULL,
  sphereL_target_fname = NULL,
  sphereR_target_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

remapCIfTI(
  x,
  cifti_target_fname = NULL,
  remap_method = c("adaptive", "barycentric"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  areaL_target_fname = NULL,
  areaR_target_fname = NULL,
  sphereL_original_fname = NULL,
  sphereR_original_fname = NULL,
  sphereL_target_fname = NULL,
  sphereR_target_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

remapcii(
  x,
  cifti_target_fname = NULL,
  remap_method = c("adaptive", "barycentric"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  areaL_target_fname = NULL,
  areaR_target_fname = NULL,
  sphereL_original_fname = NULL,
  sphereR_original_fname = NULL,
  sphereL_target_fname = NULL,
  sphereR_target_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

remap_xifti(
  x,
  cifti_target_fname = NULL,
  remap_method = c("adaptive", "barycentric"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  areaL_target_fname = NULL,
  areaR_target_fname = NULL,
  sphereL_original_fname = NULL,
  sphereR_original_fname = NULL,
  sphereL_target_fname = NULL,
  sphereR_target_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)
}
\arguments{
\item{x}{The CIFTI file name or \code{"xifti"} object to resample.}

\item{cifti_target_fname}{File name for the resampled CIFTI. Will be placed
in \code{write_dir}. If \code{NULL}, will be written to "resampled.d*.nii".
\code{write_dir} will be appended to the beginning of the path.}

\item{remap_method}{\code{"adaptive"} (default) or \code{"adaptive"}
resampling. These options correspond to the Workbench command options
\code{"BARYCENTRIC"} and \code{"ADAP_BARY_AREA"}, respectively.

For remapping fs_LR group data to fsaverage, barycentric should be
used. For remapping FreeSurfer fsaverage group data to fs_LR, adaptive
should be used.}

\item{areaL_original_fname, areaL_target_fname}{File paths to the left cortex
surfaces to use for vertex area correction during adaptive resampling.
Required if \code{remap_method} is \code{"adaptive"}.}

\item{areaR_original_fname, areaR_target_fname, sphereR_original_fname, sphereR_target_fname}{See the corresponding arguments for the left cortex.}

\item{sphereL_original_fname, sphereL_target_fname}{File paths to the sphere
surfaces in the original and target spaces, for the left cortex.}

\item{write_dir}{Where to write the resampled CIFTI (and surfaces if present.)
If \code{NULL} (default), will use the current working directory if \code{x}
was a CIFTI file, and a temporary directory if \code{x} was a \code{"xifti"}
object.}

\item{mwall_values}{If the medial wall locations are not indicated in the
CIFTI, and if \code{ROIcortexL/R_original_fname} is not provided, then use
these values to infer the medial wall mask. Default: \code{c(NA, NaN)}. If
\code{NULL}, do not attempt to infer the medial wall.

Correctly indicating the medial wall locations is important for remapping,
because the medial wall mask is taken into account during remapping
calculations.}

\item{verbose}{Should occasional updates be printed? Default: \code{TRUE}.}
}
\description{
Remap CIFTI data between two different spaces, such as between FreeSurfer
fsaverage group data and fs_LR group data.
}
\details{
Can accept a \code{"xifti"} object as well as a path to a CIFTI-file. If
the input \code{"xifti"} object has surface geometry, it will be removed.

This function is in active development: its arguments and behavior may
change greatly in future versions of the package.
}
\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_to_dlabel}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{move_to_submask}()},
\code{\link{newdata_xifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}
}
\concept{manipulating xifti}
