% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.xifti.R
\name{as.xifti}
\alias{as.xifti}
\alias{as_xifti}
\alias{as.cifti}
\alias{as_cifti}
\title{Assemble a \code{"xifti"} from data}
\usage{
as.xifti(
  cortexL = NULL,
  cortexL_mwall = NULL,
  cortexR = NULL,
  cortexR_mwall = NULL,
  mwall_values = c(NA, NaN),
  subcortVol = NULL,
  subcortLabs = NULL,
  subcortMask = NULL,
  surfL = NULL,
  surfR = NULL,
  col_names = NULL,
  HCP_32k_auto_mwall = TRUE,
  validate = TRUE
)

as_xifti(
  cortexL = NULL,
  cortexL_mwall = NULL,
  cortexR = NULL,
  cortexR_mwall = NULL,
  mwall_values = c(NA, NaN),
  subcortVol = NULL,
  subcortLabs = NULL,
  subcortMask = NULL,
  surfL = NULL,
  surfR = NULL
)

as.cifti(
  cortexL = NULL,
  cortexL_mwall = NULL,
  cortexR = NULL,
  cortexR_mwall = NULL,
  mwall_values = c(NA, NaN),
  subcortVol = NULL,
  subcortLabs = NULL,
  subcortMask = NULL,
  surfL = NULL,
  surfR = NULL
)

as_cifti(
  cortexL = NULL,
  cortexL_mwall = NULL,
  cortexR = NULL,
  cortexR_mwall = NULL,
  mwall_values = c(NA, NaN),
  subcortVol = NULL,
  subcortLabs = NULL,
  subcortMask = NULL,
  surfL = NULL,
  surfR = NULL
)
}
\arguments{
\item{cortexL, cortexL_mwall}{Left cortex data and ROI. Each must be a data
matrix or vector.

If \code{cortexL_mwall} is not provided, \code{cortexL} should have data for
all vertices on the left cortical surface (\eqn{V_L \times T} data matrix). There
will not be a mask for the medial wall. Not providing the medial wall mask
is appropriate for ".dlabels.nii" files where the medial wall may have its
own label and therefore should not be treated as missing data.

If \code{cortexL_mwall} is provided, \code{cortexL} should either have data
for all vertices on the left cortical surface (\eqn{V_L \times T} data matrix, with
filler values e.g. \code{0} or \code{NaN} for medial wall vertices), or have data
only for non-medial wall vertices (\eqn{(V_L - mwall_L) \times T} data matrix).
The medial wall mask will be the \code{0} values in \code{cortexL_mwall}.
The medial wall mask should be provided whenever the medial wall should be
treated as missing data.

Since the unmasked cortices must have the same number of vertices,
\code{V_L} should match \code{V_R}.}

\item{cortexR, cortexR_mwall}{Right cortex data and ROI. Each must be a data
matrix or vector.

If \code{cortexR_mwall} is not provided, \code{cortexR} should have data for
all vertices on the right cortical surface (\eqn{V_R \times T} data mre
will not be a mask for the medial wall. Not providing the medial wall mask
is appropriate for ".dlabels.nii" files where the medial wall may have its
own label and therefore should not be treated as missing data.

If \code{cortexR_mwall} is provided, \code{cortexR} should either have data
for all vertices on the right cortical surface (\eqn{V_R \times T} data matrix, with
filler values e.g. \code{0} or \code{NaN} for medial wall vertices), or have data
only for non-medial wall vertices (\eqn{(V_R - mwall_R) \times T} data matrix).
The medial wall mask will be the \code{0} values in \code{cortexR_mwall}.
The medial wall mask should be provided whenever the medial wall should be
treated as missing data.

Since the unmasked cortices must have the same number of vertices,
\code{V_L} should match \code{V_R}.}

\item{mwall_values}{If \code{cortex[L/R]_mwall} was not provided, or if it
was invalid (i.e. bad length or all \code{TRUE}), the medial wall mask will
be inferred from rows in \code{cortex[L/R]} that are constantly one of these
values. Default: \code{c(NA, NaN)}. If \code{NULL}, do not attempt to infer
the medial wall from the data values. \code{NULL} should be used if \code{NA}
or \code{NaN} are legitimate values that non-medial wall vertices might
take on.}

\item{subcortVol, subcortLabs, subcortMask}{\code{subcortVol} represents the
data values of the subcortex. It is either a 3D/4D numeric array
(\eqn{i \times j \times k \times T}), or a vectorized matrix (\eqn{V_S} voxels by \eqn{T}
measurements). If it's vectorized, the voxels should be in spatial order
(\eqn{i} index increasing fastest, then \eqn{j}, then \eqn{k}).

\code{subcortLabs} represents the brainstructure labels of each voxel: see
\code{\link{substructure_table}}. It is either a 3D data array
(\eqn{i \times j \times k}) of integer brainstructure indices, or a \eqn{V_S} length
vector in spatial order with brainstructure names as factors or integer
indices. The indices should be 3-22 (1 and 2 correspond to left and right
cortex, respectively), with 0 representing out-of-mask voxels if a 3D array
is being provided.

\code{subcortMask} is logical 3D data array (\eqn{i \times j \times k}) where \code{TRUE}
values indicate subcortical voxels (in-mask). If it is not provided, the
mask will be inferred from voxels with labels \code{0}, \code{NA}, or
\code{NaN} in \code{subcortLabs}. If \code{subcortLabs} are vectorized and
\code{subcortMask} is not provided, the mask cannot be inferred so an error
will occur.}

\item{surfL, surfR}{(Optional) Surface geometries for the left or right cortex.
Can be a surface GIFTI file path or \code{"surf"} object; see
\code{\link{make_surf}} for a full description of valid inputs.}

\item{col_names}{Names of each measurement/column in the data.}

\item{HCP_32k_auto_mwall}{If left and/or right cortex data is provided, and
the number of vertices matches that of the HCP 32k mesh (29696 on left, and
29716 on right), should the medial wall masks be added to the \code{"xifti"}
if not provided? Default: \code{TRUE}.}

\item{validate}{Validate that the result is a \code{"xifti"}? Default:
\code{TRUE}. If \code{FALSE}, the result may not be properly formatted
if the inputs were invalid.}
}
\value{
A \code{"xifti"}
}
\description{
Assembles cortical data, subcortical data, and/or surface geometry to form a
\code{"xifti"}. The inputs must be data objects (vectors, matrices or
arrays, depending on the argument).
}
\details{
Each data or surface component is optional. Metadata components
(\code{cortex[L/R]_mwall}, \code{subcortLabs}, and \code{subcortMask}) will
be ignored if its corresponding data component is not provided. If no data or
surface components are provided, then the \code{\link{template_xifti}} will
be returned.

If cortical data are provided without a corresponding medial wall mask, or
if the provided mask is invalid or empty, then the medial wall will be
inferred from data rows that are constantly a value in \code{mwall_values}.
But if \code{mwall_values} is \code{NULL}, no attempt to infer the medial
wall will be made and the medial wall metadata entry will be \code{NULL}.

The total number of grayordinates will be
\eqn{G = (V_L - mwall_L) + (V_R - mwall_R) + V_S}: \eqn{V_L - mwall_L} left
vertices, \eqn{V_R - mwall_R} right vertices and \eqn{V_S} subcortical
voxels. \eqn{T}, the total number of measurements (columns of data), must be
the same for each brainstructure.
}
\seealso{
Other reading: 
\code{\link{info_cifti}()},
\code{\link{load_parc}()},
\code{\link{load_surf}()},
\code{\link{read_cifti}()},
\code{\link{read_surf}()},
\code{\link{read_xifti2}()}
}
\concept{reading}
