% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cifti.R
\name{read_cifti}
\alias{read_cifti}
\alias{readCIfTI}
\alias{readcii}
\alias{read_xifti}
\title{Read a CIFTI file}
\usage{
read_cifti(
  cifti_fname = NULL,
  surfL_fname = NULL,
  surfR_fname = NULL,
  brainstructures = c("left", "right"),
  idx = NULL,
  resamp_res = NULL,
  flat = FALSE,
  mwall_values = c(NA, NaN),
  verbose = FALSE,
  ...
)

readCIfTI(
  cifti_fname = NULL,
  surfL_fname = NULL,
  surfR_fname = NULL,
  brainstructures = c("left", "right"),
  idx = NULL,
  resamp_res = NULL,
  flat = FALSE,
  mwall_values = c(NA, NaN),
  verbose = FALSE,
  ...
)

readcii(
  cifti_fname = NULL,
  surfL_fname = NULL,
  surfR_fname = NULL,
  brainstructures = c("left", "right"),
  idx = NULL,
  resamp_res = NULL,
  flat = FALSE,
  mwall_values = c(NA, NaN),
  verbose = FALSE,
  ...
)

read_xifti(
  cifti_fname = NULL,
  surfL_fname = NULL,
  surfR_fname = NULL,
  brainstructures = c("left", "right"),
  idx = NULL,
  resamp_res = NULL,
  flat = FALSE,
  mwall_values = c(NA, NaN),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{cifti_fname}{File path to a CIFTI file (ending in ".d*.nii").}

\item{surfL_fname}{(Optional) File path to a GIFTI surface geometry
file representing the left cortex.}

\item{surfR_fname}{(Optional) File path to a GIFTI surface geometry
file representing the right cortex.}

\item{brainstructures}{Character vector indicating which brain structure(s)
to obtain: \code{"left"} (left cortex), \code{"right"} (right cortex)
and/or \code{"subcortical"} (subcortex and cerebellum). Can also be
\code{"all"} (obtain all three brain structures). Default:
\code{c("left","right")} (cortex only).

If a brain structure is indicated but does not exist in the CIFTI file, a
warning will occur and that brain structure will be skipped.}

\item{idx}{Numeric vector indicating the data indices (columns) to read. If
\code{NULL} (default), read in all the data. Must be a subset of the indices
present in the file, or an error will occur.

For high-resolution CIFTI files, reading in only a subset of the data saves
memory, but will be slower than reading in the entire file due to the
required intermediate steps.}

\item{resamp_res}{Resolution to resample the cortical data and surface to.
Default: \code{NULL} (do not resample). If not \code{NULL}, the data will
have to be read in with \code{-cifti-separate}, which is slower than
\code{-cifti-convert -to-gifti-ext}.}

\item{flat}{Should the result be flattened into a single matrix?

If \code{FALSE} (default), the result will be a \code{"xifti"} object.

If \code{TRUE}, the result will be a \eqn{T x G} matrix (\eqn{T}
measurements, \eqn{G} greyordinates not including the medial wall if it's
excluded from the ROI). All below arguments will be ignored because the
brain structures cannot be identified. Surfaces will not be appended.
Resampling is also not possible. \code{flat==TRUE} is the fastest way to
read in just the CIFTI data.

If \code{TRUE}, the greyordinates will be ordered by left cortex, right
cortex, and then subcortex. Subcortical voxels will be ordered by alphabetical
label. However, where each brainstructure (and subcortical structure) begins
and ends cannot be determined. The medial wall locations and subcortical
brain mask are also not included. The data matrix will be identical to that
created by \code{-cifti-convert -to-gifti-ext}.}

\item{mwall_values}{If the medial wall locations are not indicated in the
CIFTI, use these values to infer the medial wall mask. Default:
\code{c(NA, NaN)}. If \code{NULL}, do not attempt to infer the medial wall.}

\item{verbose}{Should occasional updates be printed? Default: \code{FALSE}.}

\item{...}{Additional arguments to \code{\link{read_cifti_convert}} or
\code{\link{read_cifti_separate}}.}
}
\value{
If \code{!flat}, a \code{"xifti"} object. Otherwise, a \eqn{T x G}
matrix (\eqn{T} measurements, \eqn{G} greyordinates).
}
\description{
Read in a CIFTI file as a \code{"xifti"} object.
}
\details{
First, metadata is obtained with \code{\link{info_cifti}}. Then, if no
resampling is requested, the \code{-cifti-convert -to-gifti-ext} Workbench
Command is used to "flatten" the data and save it as a metric GIFTI file,
which is read in and separated by brainstructure according to the metadata
(\code{\link{read_cifti_convert}}). Otherwise, if sampling is requested,
then the CIFTI is separated into its GIFTI and NIFTI components, resampled,
and then re-assembled (\code{\link{read_cifti_separate}}). The former is
much faster for large CIFTI files, so the latter is only used when necessary
for resampling.

If \code{cifti_fname} is not provided, then only the surfaces are read in.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-cifti-convert"} Workbench command if
resampling is not needed, and the \code{"-cifti-separate"} Workbench command
if resampling is needed.
}

\section{Label Levels}{

\code{xifti$meta$subcort$labels} is a factor with the following levels:

\enumerate{
\item{Cortex-L}
\item{Cortex-R}
\item{Accumbens-L}
\item{Accumbens-R}
\item{Amygdala-L}
\item{Amygdala-R}
\item{Brain Stem}
\item{Caudate-L}
\item{Caudate-R}
\item{Cerebellum-L}
\item{Cerebellum-R}
\item{Diencephalon-L}
\item{Diencephalon-R}
\item{Hippocampus-L}
\item{Hippocampus-R}
\item{Pallidum-L}
\item{Pallidum-R}
\item{Putamen-L}
\item{Putamen-R}
\item{Thalamus-L}
\item{Thalamus-R}
}

These correspond to the same structures as given by
\code{ft_read_cifti} in the \code{cifti-matlab} MATLAB toolbox. Note that
the first two levels (left and right cortex) are not used.
}

\seealso{
Other commonly-used functions: 
\code{\link{is.cifti}()},
\code{\link{resample_cifti}()},
\code{\link{smooth_cifti}()},
\code{\link{view_xifti_surface}()},
\code{\link{view_xifti_volume}()},
\code{\link{write_cifti}()}

Other functions for reading in CIFTI or GIFTI metric data: 
\code{\link{as.xifti}()},
\code{\link{info_cifti}()},
\code{\link{load_parc}()},
\code{\link{load_surf}()},
\code{\link{read_surf}()},
\code{\link{read_xifti2}()}
}
\concept{common}
\concept{reading}
