% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidying_functions.R
\name{norm_standardize}
\alias{norm_standardize}
\title{Standardize circumplex scales using normative data}
\usage{
norm_standardize(
  data,
  scales,
  angles = octants(),
  instrument,
  sample = 1,
  prefix = "",
  suffix = "_z",
  append = TRUE
)
}
\arguments{
\item{data}{Required. A data frame or matrix containing at least circumplex
scales.}

\item{scales}{Required. A character vector containing the column names, or a
numeric vector containing the column indexes, for the variables (scale
scores) to be standardized.}

\item{angles}{Required. A numeric vector containing the angular displacement
of each circumplex scale included in \code{scales} (in degrees). Can use the
\code{octants()}, \code{poles()}, or \code{quadrants()} convenience functions.}

\item{instrument}{Required. An instrument object from the package. To see the
available circumplex instruments, see \code{instruments()}.}

\item{sample}{Required. An integer corresponding to the normative sample to
use in standardizing the scale scores (default = 1). See \code{?norms} to
see the normative samples available for an instrument.}

\item{prefix}{Optional. A string to include at the beginning of the newly
calculated scale variables' names, before the scale name and \code{suffix}
(default = "").}

\item{suffix}{Optional. A string to include at the end of the newly
calculated scale variables' names, after the scale name and \code{prefix}
(default = "_z").}

\item{append}{Optional. A logical that determines whether the calculated
standardized scores should be added as columns to \code{data} in the output or
the standardized scores alone should be output (default = TRUE).}
}
\value{
A data frame that contains the norm-standardized versions of \code{scales}.
}
\description{
Take in a data frame containing circumplex scales, angle definitions for each
scale, and normative data (from the package or custom) and return that same
data frame with each specified circumplex scale transformed into standard
scores (i.e., z-scores) based on comparison to the normative data.
}
\examples{
data("jz2017")
instrument("iipsc")
norm_standardize(jz2017, scales = 2:9, instrument = iipsc, sample = 1)
}
\seealso{
Other tidying functions: 
\code{\link{ipsatize}()},
\code{\link{score}()}
}
\concept{tidying functions}
