% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_list_api_keys}
\alias{users_list_api_keys}
\title{Show API keys belonging to the specified user}
\usage{
users_list_api_keys(id, limit = NULL, page_num = NULL, order = NULL,
  order_dir = NULL)
}
\arguments{
\item{id}{string required. The ID of the user or 'me'.}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the API key.}
\item{name}{string, The name of the API key.}
\item{expiresAt}{string, The date and time when the key expired.}
\item{createdAt}{string, The date and time when the key was created.}
\item{revokedAt}{string, The date and time when the key was revoked.}
\item{lastUsedAt}{string, The date and time when the key was last used.}
\item{scopes}{array, The scopes which the key is permissioned on.}
\item{useCount}{integer, The number of times the key has been used.}
\item{expired}{boolean, True if the key has expired.}
\item{active}{boolean, True if the key has neither expired nor been revoked.}
\item{constraintCount}{integer, The number of constraints on the created key}
}
\description{
Show API keys belonging to the specified user
}
