% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_patch_kubernetes}
\alias{clusters_patch_kubernetes}
\title{Update a Kubernetes Cluster}
\usage{
clusters_patch_kubernetes(id, raw_cluster_slug = NULL, is_nat_enabled = NULL)
}
\arguments{
\item{id}{integer required. The ID of this cluster.}

\item{raw_cluster_slug}{string optional. The slug of this cluster's raw configuration.}

\item{is_nat_enabled}{boolean optional. Whether this cluster needs a NAT gateway or not.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this cluster.}
\item{organizationId}{string, The id of this cluster's organization.}
\item{organizationName}{string, The name of this cluster's organization.}
\item{organizationSlug}{string, The slug of this cluster's organization.}
\item{rawClusterSlug}{string, The slug of this cluster's raw configuration.}
\item{customPartitions}{boolean, Whether this cluster has a custom partition configuration.}
\item{clusterPartitions}{array, An array containing the following fields: 
\itemize{
\item clusterPartitionId integer, The ID of this cluster partition.
\item name string, The name of the cluster partition.
\item labels array, Labels associated with this partition.
\item instanceConfigs array, The instances configured for this cluster partition.
\item defaultInstanceConfigId integer, The id of the InstanceConfig that is the default for this partition.
}}
\item{isNatEnabled}{boolean, Whether this cluster needs a NAT gateway or not.}
\item{hours}{number, The number of hours used this month for this cluster.}
}
\description{
Update a Kubernetes Cluster
}
