% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{files_post}
\alias{files_post}
\title{Initiate an upload of a file into the platform}
\usage{
files_post(name, expires_at = NULL)
}
\arguments{
\item{name}{string required. The file name.}

\item{expires_at}{string optional. The date and time the file will expire. If not specified, the file will expire in 30 days. To keep a file indefinitely, specify null.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the file.}
\item{name}{string, The file name.}
\item{createdAt}{string, The date and time the file was created.}
\item{fileSize}{integer, The file size.}
\item{expiresAt}{string, The date and time the file will expire. If not specified, the file will expire in 30 days. To keep a file indefinitely, specify null.}
\item{uploadUrl}{string, The URL that may be used to upload a file. To use the upload URL, initiate a POST request to the given URL with the file you wish to import as the "file" form field.}
\item{uploadFields}{list, A hash containing the form fields to be included with the POST request.}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
}
\description{
Initiate an upload of a file into the platform
}
