% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize}
\alias{standardize}
\title{Rescale variables, possibly excluding some columns}
\usage{
standardize(x, skip_vars = NULL, ...)
}
\arguments{
\item{x}{Dataframe or matrix, assumed to have column names.}

\item{skip_vars}{List of names of variables not to scale.}

\item{...}{Extra arguments passed-through to base::scale}
}
\value{
Data-frame with appropriate variables scaled.
}
\description{
Simple extension to base::scale() to skip columns.
}
\examples{

library(ck37r)

data(Boston, package = "MASS")

# Don't scale our outcome variable.
data = standardize(Boston, skip_vars = "medv")

summary(data)

}
\seealso{
\code{\link[base]{scale}}
}
