% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SuperLearner.R
\name{plot.SuperLearner}
\alias{plot.SuperLearner}
\title{Plot estimated risk and confidence interval for each learner}
\usage{
\method{plot}{SuperLearner}(x, y = x$Y, constant = qnorm(0.975), sort = T, ...)
}
\arguments{
\item{x}{SuperLearner result object}

\item{y}{Outcome vector}

\item{constant}{Multiplier of the standard error for confidence interval
construction.}

\item{sort}{If TRUE re-orders the results by risk estimate.}

\item{...}{Any remaining arguments (unused).}
}
\value{
plot object; print to display.
}
\description{
Does not include SuperLearner or Discrete SL results as that requires
CV.SuperLearner to estimate the standard errors.
}
\examples{
library(SuperLearner)
library(ck37r)

data(Boston, package = "MASS")

set.seed(1)
sl = SuperLearner(Boston$medv, subset(Boston, select = -medv),
                  family = gaussian(),
                  SL.library = c("SL.mean", "SL.glm"))

sl
plot(sl, y = Boston$chas)

}
\references{
Polley EC, van der Laan MJ (2010) Super Learner in Prediction. U.C. Berkeley
Division of Biostatistics Working Paper Series. Paper 226.
http://biostats.bepress.com/ucbbiostat/paper266/

van der Laan, M. J., Polley, E. C. and Hubbard, A. E. (2007) Super Learner.
Statistical Applications of Genetics and Molecular Biology, 6, article 25.
http://www.degruyter.com/view/j/sagmb.2007.6.issue-1/sagmb.2007.6.1.1309/sagmb.2007.6.1.1309.xml
}
\seealso{
\code{\link[SuperLearner]{SuperLearner}}
}
