% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/package_patch.R
\name{package_patch}
\alias{package_patch}
\title{Update a package's metadata}
\usage{
package_patch(x, id, key = get_default_key(), url = get_default_url(),
  as = "list", ...)
}
\arguments{
\item{x}{(list) A list with key-value pairs}

\item{id}{(character) Resource ID to update (required)}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Update a package's metadata
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org", key = getOption("ckan_demo_key"))

# Create a package
(res <- package_create("hello-world7", author="Jane Doe"))

# Get a resource
res <- package_show(res$id)
res$title
res$author_email

# Make some changes
x <- list(title = "!hello there world! bye")
package_patch(x, id = res$id)
}
}

