% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Simulate model parameters}
\usage{
sim(fit, n = 1000, vcov = NULL, coefs = NULL, dist = NULL)
}
\arguments{
\item{fit}{a model fit, such as the output of a call to \code{\link[=lm]{lm()}} or \code{\link[=glm]{glm()}}. Can be left unspecified if \code{coefs} and \code{vcov} are not functions.}

\item{n}{the number of simulations to run; default is 1000. More is always better but resulting calculations will take longer.}

\item{vcov}{either a square covariance matrix of the coefficient covariance estimates or a function to use to extract it from \code{fit}. By default, uses \code{\link[stats:vcov]{stats::vcov()}} or \code{\link[insight:get_varcov]{insight::get_varcov()}} if that doesn't work.}

\item{coefs}{either a vector of coefficient estimates or a function to use to extract it from \code{fit}. By default, uses \code{\link[stats:coef]{stats::coef()}} or \code{\link[insight:get_parameters]{insight::get_parameters()}} if that doesn't work.}

\item{dist}{a string containing the name of the multivariate distribution to use to draw simulated coefficients. Should be one of \code{"normal"} (multivariate normal distribution) or \code{"t({#})"} (multivariate t distribution), where \verb{\{#\}} corresponds to the desired degrees of freedom (e.g., \code{"t(100)"}). If \code{NULL}, the right distribution to use will be determined based on heuristics; see Details.}
}
\value{
A \code{clarify_sim} object, which has the following components:
\item{sim.coefs}{a matrix containing the simulated coefficients with a column for each coefficient and a row for each simulation}
\item{coefs}{the original coefficients extracted from \code{fit} or supplied to \code{coefs}.}
\item{vcov}{the covariance matrix of the coefficients extracted from \code{fit} or supplied to \code{vcov}}
\item{fit}{the original model fit supplied to \code{fit}}
The \code{"dist"} attribute contains \code{"normal"} if the coefficients were sampled from a multivariate normal distribution and \code{"t(df)"} if sampled from a multivariate t distribution. The \code{"clarify_hash"} attribute contains a unique hash generated by \code{\link[rlang:hash]{rlang::hash()}}.
}
\description{
\code{sim()} simulates model parameters from a multivariate normal or t distribution that are then used by \code{\link[=sim_apply]{sim_apply()}} to calculate quantities of interest.
}
\details{
When \code{dist} is \code{NULL}, \code{sim()} samples from a multivariate normal or t distribution depending on the degrees of freedom extracted from \code{insight::get_df(., type = "wald")}. If \code{Inf}, a normal distribution will be used; otherwise, a t-distribution with the returned degrees of freedom will be used. Models not supported by \code{insight} will use a normal distribution.

When a multivariate normal is used, it is sampled from with means equal to the estimated coefficients and the parameter covariance matrix as the covariance matrix using \code{\link[mvnfast:rmvn]{mvnfast::rmvn()}}. When a multivariate t distribution is used, it is sampled from with means equal to the estimated coefficients and scaling matrix equal to \code{cov*(df - 2)/df}, where \code{cov} is the parameter covariance matrix and \code{df} is the residual degrees of freedom for the model, using \code{\link[mvnfast:rmvt]{mvnfast::rmvt()}}.
}
\examples{

data("lalonde", package = "MatchIt")
fit <- lm(re78 ~ treat * (age + race + nodegree + re74), data = lalonde)

# Simulate coefficients
s <- sim(fit)
s

## Could also use a robust covariance matrix, e.g.,
s <- sim(fit, vcov = "HC3")

# Simulated coefficients assuming a normal distribution
# for coefficients; default for `lm` objects is a t-
# distribution
s <- sim(fit, dist = "normal")
s

}
\seealso{
\itemize{
\item \code{\link[=misim]{misim()}} for simulating model coefficients after multiple imputation
\item \code{\link[=sim_apply]{sim_apply()}} for applying a function to each set of simulated coefficients
\item \code{\link[=sim_ame]{sim_ame()}} for computing average marginal effects in each simulation draw
\item \code{\link[=sim_setx]{sim_setx()}} for computing marginal predictions and first differences at typical values in each simulation draw
\item \code{\link[=sim_adrf]{sim_adrf()}} for computing average dose-response functions in each simulation draw
}
}
