% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crayon.R
\name{ansi-styles}
\alias{ansi-styles}
\alias{bg_black}
\alias{bg_blue}
\alias{bg_cyan}
\alias{bg_green}
\alias{bg_magenta}
\alias{bg_red}
\alias{bg_white}
\alias{bg_yellow}
\alias{col_black}
\alias{col_blue}
\alias{col_cyan}
\alias{col_green}
\alias{col_magenta}
\alias{col_red}
\alias{col_white}
\alias{col_yellow}
\alias{col_grey}
\alias{col_silver}
\alias{style_dim}
\alias{style_blurred}
\alias{style_bold}
\alias{style_hidden}
\alias{style_inverse}
\alias{style_italic}
\alias{style_reset}
\alias{style_strikethrough}
\alias{style_underline}
\title{ANSI colored text}
\usage{
bg_black(...)

bg_blue(...)

bg_cyan(...)

bg_green(...)

bg_magenta(...)

bg_red(...)

bg_white(...)

bg_yellow(...)

col_black(...)

col_blue(...)

col_cyan(...)

col_green(...)

col_magenta(...)

col_red(...)

col_white(...)

col_yellow(...)

col_grey(...)

col_silver(...)

style_dim(...)

style_blurred(...)

style_bold(...)

style_hidden(...)

style_inverse(...)

style_italic(...)

style_reset(...)

style_strikethrough(...)

style_underline(...)
}
\arguments{
\item{...}{Character strings, they will be pasted together with
\code{paste0()}, before applying the style function.}
}
\value{
An ANSI string (class \code{ansi_string}), that contains ANSI
sequences, if the current platform supports them. You can simply
use \code{cat()} to print them to the terminal.
}
\description{
cli has a number of functions to color and style text at the command
line. These all use the crayon package under the hood, but provide a
slightly simpler interface.
}
\details{
The \code{col_*} functions change the (foreground) color to the text.
These are the eight original ANSI colors. Note that in some terminals,
they might actually look differently, as terminals have their own
settings for how to show them.

The \code{bg_*} functions change the background color of the text.
These are the eight original ANSI background colors. These, too, can
vary in appearence, depending on terminal settings.

The \code{style_*} functions apply other styling to the text. The currently
supported styling funtions are:
\itemize{
\item \code{style_reset()} to remove any style, including color,
\item \code{style_bold()} for boldface / strong text, although some terminals
show a bright, high intensity text instead,
\item \code{style_dim()} (or \code{style_blurred()} reduced intensity text.
\item \code{style_italic()} (not widely supported).
\item \code{style_underline()},
\item \code{style_inverse()},
\item \code{style_hidden()},
\item `style_strikethrough() (not widely supported).
}

The style functions take any number of character vectors as arguments,
and they concatenate them using \code{paste0()} before adding the style.

Styles can also be nested, and then inner style takes precedence, see
examples below.
}
\examples{
col_blue("Hello ", "world!")
cat(col_blue("Hello ", "world!"))

cat("... to highlight the", col_red("search term"),
    "in a block of text\\n")

## Style stack properly
cat(col_green(
 "I am a green line ",
 col_blue(style_underline(style_bold("with a blue substring"))),
 " that becomes green again!"
))

error <- combine_ansi_styles("red", "bold")
warn <- combine_ansi_styles("magenta", "underline")
note <- col_cyan
cat(error("Error: subscript out of bounds!\\n"))
cat(warn("Warning: shorter argument was recycled.\\n"))
cat(note("Note: no such directory.\\n"))

}
\seealso{
Other ANSI styling: \code{\link{combine_ansi_styles}},
  \code{\link{make_ansi_style}}
}
\concept{ANSI styling}
