% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_div}
\alias{cli_div}
\title{Generic CLI container}
\usage{
cli_div(
  id = NULL,
  class = NULL,
  theme = NULL,
  .auto_close = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{id}{Element id, a string. If \code{NULL}, then a new id is generated
and returned.}

\item{class}{Class name, sting. Can be used in themes.}

\item{theme}{A custom theme for the container. See \link{themes}.}

\item{.auto_close}{Whether to close the container, when the calling
function finishes (or \code{.envir} is removed, if specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-close the container if \code{.auto_close} is \code{TRUE}.}
}
\value{
The id of the new container element, invisibly.
}
\description{
See \link{containers}. A \code{cli_div} container is special, because it may
add new themes, that are valid within the container.
}
\examples{
## div with custom theme
d <- cli_div(theme = list(h1 = list(color = "blue",
                                    "font-weight" = "bold")))
cli_h1("Custom title")
cli_end(d)

## Close automatically
div <- function() {
  cli_div(class = "tmp", theme = list(.tmp = list(color = "yellow")))
  cli_text("This is yellow")
}
div()
cli_text("This is not yellow any more")
}
