% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-client.R
\name{cli_progress_bar}
\alias{cli_progress_bar}
\alias{__cli_update_due}
\alias{cli_tick_reset}
\alias{ccli_tick_reset}
\alias{ticking}
\alias{cli_progress_update}
\alias{cli_progress_done}
\title{cli progress bars}
\usage{
cli_progress_bar(
  name = NULL,
  status = NULL,
  type = c("iterator", "tasks", "download", "custom"),
  total = NA,
  format = NULL,
  format_done = NULL,
  format_failed = NULL,
  clear = getOption("cli.progress_clear", TRUE),
  current = TRUE,
  auto_terminate = type != "download",
  extra = NULL,
  .auto_close = TRUE,
  .envir = parent.frame()
)

cli_progress_update(
  inc = NULL,
  set = NULL,
  total = NULL,
  status = NULL,
  extra = NULL,
  id = NULL,
  force = FALSE,
  .envir = parent.frame()
)

cli_progress_done(id = NULL, .envir = parent.frame(), result = "done")
}
\arguments{
\item{name}{This is typically used as a label, and should be short,
at most 20 characters.}

\item{status}{New status string of the progress bar, if not \code{NULL}.}

\item{type}{Type of the progress bar. It is used to select a default
display if \code{format} is not specified. Currently supported types:
\itemize{
\item \code{iterator}: e.g. a for loop or a mapping function,
\item \code{tasks}: a (typically small) number of tasks,
\item \code{download}: download of one file,
\item \code{custom}: custom type, \code{format} must not be \code{NULL} for this type.
}}

\item{total}{Total number of progress units, or \code{NA} if it is unknown.
\code{cli_progress_update()} can update the total number of units. This is
handy if you don't know the size of a download at the beginning, and
also in some other casees. If \code{format} (plus \code{format_done} and
\code{format_done}) will be updated if you change \code{total} from \code{NA} to a
number, if you specify \code{NULL} for \code{format}. I.e. default format strings
will be updated, custom ones won't be.}

\item{format}{Format string. It has to be specified for custom progress
bars, otherwise it is optional, and a default display is selected
based on the progress bat type and whether the number of total units
is known. Format strings may contain glue substitution, the support
pluralization and cli styling.}

\item{format_done}{Format string for successful termination. By default
the same as \code{format}.}

\item{format_failed}{Format string for unsuccessful termination. By
default the same as \code{format}.}

\item{clear}{Whether to remove the progress bar from the screen after
it has temrinated.}

\item{current}{Whether to use this progress bar as the current progress
bar of the calling function. See more at 'The current progress bar'
below.}

\item{auto_terminate}{Whether to terminate the progress bar if the
number of current units reaches the number of total units.}

\item{extra}{Extra data to add to the progress bar. This can be
used in custom format strings for example. It should be a named list.
\code{cli_progress_update()} can update the extra data.}

\item{.auto_close}{Whether to terminate the progress bar when the
calling function (or the one with execution environment in \code{.envir}
exits. (Auto termination does not work for progress bars created
from the global environment, e.g. from a script.)}

\item{.envir}{The environment to use for auto-termination and for glue
substitution. It is also used to find and set the current progress bar.}

\item{inc}{Increment in progress units. This is ignored if \code{set} is
not \code{NULL}.}

\item{set}{Set the current number of progress units to this value.
Ignored if \code{NULL}.}

\item{id}{Progress bar to update or terminate. If \code{NULL}, then the
current progress bar of the calling function (or \code{.envir} if
specified) is updated or terminated.}

\item{force}{Whether to force a display update, even if no update is
due.}

\item{result}{String to select successful or unsuccessful termination.
It is only used if the progress bar is not cleared from the screen.
It can be one of \code{"done"}, \code{"failed"}, \code{"clear"}, and \code{"auto"}.}
}
\value{
\code{cli_progress_bar()} returns the id of the new progress bar.
The id is a string constant.
\subsection{The current progress bar}{

If \code{current = TRUE} (the default), then the new progress bar will be
the \emph{current} progress bar of the calling frame. The previous current
progress bar of the same frame, if there is any, is terminated.
}

\code{cli_progress_update()} returns the id of the progress bar,
invisibly.

\code{cli_progress_done()} returns \code{TRUE}, invisibly, always.
}
\description{
This is the reference manual of the three functions that create,
update and terminate progress bars. For a tutorial see the
\href{https://cli.r-lib.org/articles/pluralization.html}{cli progress bars}.

\code{cli_progress_bar()} creates a progress bar.

\code{cli_progress_update()} updates the state of a progress bar, and
potentially the display as well.

\code{cli_progress_done()} terminates a progress bar.
}
\details{
\code{cli_progress_update()} updates the state of the progress bar and
potentially outputs the new progress bar to the display as well.
}
\examples{
\dontshow{if (cli:::should_run_progress_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
clean <- function() {
  cli_progress_bar("Cleaning data", total = 100)
  for (i in 1:100) {
    Sys.sleep(5/100)
    cli_progress_update()
  }
}
clean()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=cli_progress_message]{cli_progress_message()}} and \code{\link[=cli_progress_step]{cli_progress_step()}} for simpler
progress messages.
}
