% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark.R
\name{spark_bar}
\alias{spark_bar}
\title{Draw a sparkline bar graph with unicode block characters}
\usage{
spark_bar(x)
}
\arguments{
\item{x}{A numeric vector between 0 and 1}
}
\description{
Rendered using \href{https://en.wikipedia.org/wiki/Block_Elements}{block elements}.
In most common fixed width fonts these are rendered wider than regular
characters which means they are not suitable if you need precise alignment.
}
\details{
You might want to avoid sparklines on non-UTF-8 systems, because they
do not look good. You can use \code{\link[=is_utf8_output]{is_utf8_output()}} to test for support
for them.
}
\examples{
x <- seq(0, 1, length = 6)
spark_bar(x)
spark_bar(sample(x))

spark_bar(seq(0, 1, length = 8))

# NAs are left out
spark_bar(c(0, NA, 0.5, NA, 1))
}
\seealso{
\code{\link[=spark_line]{spark_line()}}
}
