% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tools.R
\name{ggwindrose}
\alias{ggwindrose}
\title{Windrose (speed/direction) diagram}
\usage{
ggwindrose(
  speed,
  direction,
  n_directions = 8,
  n_speeds = 5,
  speed_cuts = NA,
  col_pal = "GnBu",
  legend_title = "Wind speed (m/s)",
  calm_wind = 0,
  n_col = 1,
  facet,
  plot_title = "",
  ...
)
}
\arguments{
\item{speed}{Numeric vector of wind speeds.}

\item{direction}{Numeric vector of wind directions.}

\item{n_directions}{Numeric value as the number of direction bins to plot (petals on the rose).
The number of directions defaults to 8.}

\item{n_speeds}{Numeric value as the number of equally spaced wind speed bins to plot. This is
used if \code{speed_cuts} is \code{NA} (default 5).}

\item{speed_cuts}{Numeric vector containing the cut points for the wind speed
intervals, or \code{NA} (default).}

\item{col_pal}{Character string indicating the name of the
\code{\link[RColorBrewer]{brewer.pal.info}} colour palette to be
used for plotting, see 'Palette selection' below.}

\item{legend_title}{Character string to be used for the legend title.}

\item{calm_wind}{Numeric value as the upper limit for wind speed that is considered calm (default 0).}

\item{n_col}{The number of columns of plots (default 1).}

\item{facet}{Character or factor vector of the facets used to plot the various windroses.}

\item{plot_title}{Character string to be used for the plot title.}

\item{...}{further arguments passed to \code{\link[ggplot2]{theme}}.}
}
\value{
a \code{ggplot} object.
}
\description{
Plot a windrose showing the wind speed and direction using \pkg{ggplot2}.
}
\section{Palette selection}{

Any of the sequential \code{\link[RColorBrewer]{brewer.pal.info}} colour palettes are recommended for colour plots.
}

\examples{
\dontrun{
ggwindrose(speed, direction, n_directions = 16,
n_speeds = 7, col_pal = "GnBu", legend_title = "Wind speed (m/s)",
calm_wind = 0, n_col = 1)
}

}
\seealso{
\code{\link[ggplot2]{theme}} for more possible arguments to pass to \code{ggwindrose}.
}
