% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDataADaMSDTM.R
\name{getLabelParamcd}
\alias{getLabelParamcd}
\title{Get label for a parameter code}
\usage{
getLabelParamcd(paramcd, data, paramcdVar = "PARAMCD", paramVar = "PARAM")
}
\arguments{
\item{paramcd}{Character vector with parameter code(s).}

\item{data}{Data.frame with data.}

\item{paramcdVar}{String with column containing the \code{paramcd} parameter,
'PARAMCD' by default (for ADaM format).}

\item{paramVar}{String with column containing the \code{param} parameter,
'PARAM' by default(for ADaM format).}
}
\value{
Named character vector with label for parameter code or
\code{paramcd} if label is missing.
}
\description{
This function gets the labele for a parameter code 
extracted from the 'PARAM' column.
}
\examples{
# for ADaM
data(dataADaMCDISCP01)
getLabelParamcd(paramcd = "CHOL", data = dataADaMCDISCP01$ADLBC)
# for SDTM
data(dataSDTMCDISCP01)
getLabelParamcd(
  paramcd = "ALB", 
  data = dataSDTMCDISCP01$LB, 
  paramcdVar = "LBTESTCD", 
  paramVar = "LBTEST"
)
}
\author{
Laure Cougnaud
}
