% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invalid.R
\name{clock-invalid}
\alias{clock-invalid}
\alias{invalid_detect}
\alias{invalid_any}
\alias{invalid_count}
\alias{invalid_remove}
\alias{invalid_resolve}
\title{Invalid calendar dates}
\usage{
invalid_detect(x)

invalid_any(x)

invalid_count(x)

invalid_remove(x)

invalid_resolve(x, ..., invalid = NULL)
}
\arguments{
\item{x}{\verb{[calendar]}

A calendar vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}
}
\value{
\itemize{
\item \code{invalid_detect()}: Returns a logical vector detecting invalid dates.
\item \code{invalid_any()}: Returns \code{TRUE} if any invalid dates are detected.
\item \code{invalid_count()}: Returns a single integer containing the number of
invalid dates.
\item \code{invalid_remove()}: Returns \code{x} with invalid dates removed.
\item \code{invalid_resolve()}: Returns \code{x} with invalid dates resolved using the
\code{invalid} strategy.
}
}
\description{
This family of functions is for working with \emph{invalid} calendar dates.
These represent dates that don't exist, such as
\code{year_month_day(2019, 02, 31)}.

Invalid dates are allowed in clock, provided that they are eventually
resolved by using \code{invalid_resolve()} or by manually resolving them through
arithmetic or setter functions.
}
\details{
Invalid dates must be resolved before converting them to a time point.

It is recommended to use \code{"previous"} or \code{"next"} for resolving invalid
dates, as these ensure that \emph{relative ordering} among \code{x} is maintained.
This is a often a very important property to maintain when doing time series
data analysis. See the examples for more information.
}
\examples{
# Invalid date
x <- year_month_day(2019, 04, 30:31, c(3, 2), 30, 00)
x

invalid_detect(x)

# Previous valid moment in time
x_previous <- invalid_resolve(x, invalid = "previous")
x_previous

# Previous valid day, retaining time of day
x_previous_day <- invalid_resolve(x, invalid = "previous-day")
x_previous_day

# Note that `"previous"` retains the relative ordering in `x`
x[1] < x[2]
x_previous[1] < x_previous[2]

# But `"previous-day"` here does not!
x_previous_day[1] < x_previous_day[2]

# Remove invalid dates entirely
invalid_remove(x)

y <- year_quarter_day(2019, 1, 90:92)
y

# Overflow rolls forward by the number of days between `y` and the previous
# valid date
invalid_resolve(y, invalid = "overflow")
}
