/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ChangeResourceRecordSetsRequest>, ChangeResourceRecordSetsRequest> {
    @Override
    public Request<ChangeResourceRecordSetsRequest> marshall(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        ChangeBatch changeBatchChangeBatch;
        if (changeResourceRecordSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ChangeResourceRecordSetsRequest> request = new DefaultRequest<ChangeResourceRecordSetsRequest>(changeResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2011-05-05/hostedzone/{Id}/rrset/";
        uriResourcePath = uriResourcePath.replace("{Id}", this.getString(changeResourceRecordSetsRequest.getHostedZoneId()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("&")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2011-05-05/");
        xmlWriter.startElement("ChangeResourceRecordSetsRequest");
        if (changeResourceRecordSetsRequest != null && (changeBatchChangeBatch = changeResourceRecordSetsRequest.getChangeBatch()) != null) {
            List<Change> changesList;
            xmlWriter.startElement("ChangeBatch");
            if (changeBatchChangeBatch.getComment() != null) {
                xmlWriter.startElement("Comment").value(changeBatchChangeBatch.getComment()).endElement();
            }
            if (changeBatchChangeBatch != null && (changesList = changeBatchChangeBatch.getChanges()) != null && changesList.size() > 0) {
                int changesListIndex = 1;
                xmlWriter.startElement("Changes");
                for (Change changesListValue : changesList) {
                    ResourceRecordSet resourceRecordSetResourceRecordSet;
                    xmlWriter.startElement("Change");
                    if (changesListValue.getAction() != null) {
                        xmlWriter.startElement("Action").value(changesListValue.getAction()).endElement();
                    }
                    if (changesListValue != null && (resourceRecordSetResourceRecordSet = changesListValue.getResourceRecordSet()) != null) {
                        AliasTarget aliasTargetAliasTarget;
                        List<ResourceRecord> resourceRecordsList;
                        xmlWriter.startElement("ResourceRecordSet");
                        if (resourceRecordSetResourceRecordSet.getName() != null) {
                            xmlWriter.startElement("Name").value(resourceRecordSetResourceRecordSet.getName()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getType() != null) {
                            xmlWriter.startElement("Type").value(resourceRecordSetResourceRecordSet.getType()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getSetIdentifier() != null) {
                            xmlWriter.startElement("SetIdentifier").value(resourceRecordSetResourceRecordSet.getSetIdentifier()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getWeight() != null) {
                            xmlWriter.startElement("Weight").value(resourceRecordSetResourceRecordSet.getWeight()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getTTL() != null) {
                            xmlWriter.startElement("TTL").value(resourceRecordSetResourceRecordSet.getTTL()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet != null && (resourceRecordsList = resourceRecordSetResourceRecordSet.getResourceRecords()) != null && resourceRecordsList.size() > 0) {
                            int resourceRecordsListIndex = 1;
                            xmlWriter.startElement("ResourceRecords");
                            for (ResourceRecord resourceRecordsListValue : resourceRecordsList) {
                                xmlWriter.startElement("ResourceRecord");
                                if (resourceRecordsListValue.getValue() != null) {
                                    xmlWriter.startElement("Value").value(resourceRecordsListValue.getValue()).endElement();
                                }
                                xmlWriter.endElement();
                                ++resourceRecordsListIndex;
                            }
                            xmlWriter.endElement();
                        }
                        if (resourceRecordSetResourceRecordSet != null && (aliasTargetAliasTarget = resourceRecordSetResourceRecordSet.getAliasTarget()) != null) {
                            xmlWriter.startElement("AliasTarget");
                            if (aliasTargetAliasTarget.getHostedZoneId() != null) {
                                xmlWriter.startElement("HostedZoneId").value(aliasTargetAliasTarget.getHostedZoneId()).endElement();
                            }
                            if (aliasTargetAliasTarget.getDNSName() != null) {
                                xmlWriter.startElement("DNSName").value(aliasTargetAliasTarget.getDNSName()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                    ++changesListIndex;
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes().length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

