% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plot_clusters}
\alias{plot_clusters}
\title{plot_clusters}
\usage{
plot_clusters(
  cluster_results,
  data = NULL,
  node_colours = "#fdae61",
  scale_entropy = FALSE,
  directed = TRUE
)
}
\arguments{
\item{cluster_results}{Cluster results}

\item{data}{data}

\item{node_colours}{node colours}

\item{scale_entropy}{if true, entropy measure will be used to determine size of the nodes}

\item{directed}{TRUE if nodes should be directed}
}
\value{
A summary plot of all cluster networks of class c("gg", "ggplot", "ggarrange").
}
\description{
Plot clusters
}
\examples{
\donttest{
# choose data
my_data <- BiDAG::Asia[1:2000,]
# learn clusters
cluster_results <- get_clusters(my_data)
# visualize the networks
library(ggplot2)
library(ggraph)
library(igraph)
library(ggpubr)
plot_clusters(cluster_results)
}
}
