% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lumatrix.R
\name{lumatrix}
\alias{lumatrix}
\title{LU Decomposition}
\usage{
lumatrix(m)
}
\arguments{
\item{m}{a matrix}
}
\value{
list with matrices L and U representing the LU decomposition
}
\description{
Decompose a matrix into lower- and upper-triangular matrices
}
\details{
\code{lumatrix} decomposes the matrix \code{m} into the LU
decomposition, such that m == L %*% U.
}
\examples{
A <- matrix(c(1, 2, -7, -1, -1, 1, 2, 1, 5), 3)
lumatrix(A)

}
\seealso{
Other linear: \code{\link{choleskymatrix}},
  \code{\link{detmatrix}}, \code{\link{gdls}},
  \code{\link{invmatrix}}, \code{\link{iterativematrix}},
  \code{\link{refmatrix}}, \code{\link{rowops}},
  \code{\link{tridiagmatrix}}, \code{\link{vecnorm}}
}

