% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmsafvis-package.R, R/cmsafvis.R
\docType{package}
\name{cmsafvis-package}
\alias{cmsafvis}
\alias{cmsafvis-package}
\title{cmsafvis: Tools to Visualize CM SAF NetCDF Data}
\description{
The Satellite Application Facility on Climate Monitoring (CM SAF) is a ground segment of the European Organization for the Exploitation of Meteorological Satellites (EUMETSAT) and one of EUMETSATs Satellite Application Facilities. The CM SAF contributes to the sustainable monitoring of the climate system by providing essential climate variables related to the energy and water cycle of the atmosphere (\url{https://www.cmsaf.eu}). It is a joint cooperation of eight National Meteorological and Hydrological Services. The 'cmsafvis' R-package provides a collection of R-operators for the analysis and visualization of CM SAF NetCDF data. CM SAF climate data records are provided for free via (\url{https://wui.cmsaf.eu/safira}). Detailed information and test data are provided on the CM SAF webpage (\url{http://www.cmsaf.eu/R_toolbox}).

The 'cmsafvis' plotting routines are designed to analyze climate files
by generating graphics or videos. The functions (Fieldmean, Fieldmean and anomaly plots) were designed
and tested for daily valued CM SAF NetCDF data. The functions (Absolute Map, Anomaly Map, Climatology,
Warming Stripes Plot, Time Series Plot, Trend Plot) were designed
and tested for daily or monthly valued CM SAF NetCDF data. As interface to NetCDF
data the \link[ncdf4:ncdf4-package]{ncdf4 package} is used.
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/cmsaf/cmsaf-r-tools/issues}
}


Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/cmsaf/cmsaf-r-tools/issues}
}

}
\author{
\strong{Maintainer}: Steffen Kothe \email{Steffen.Kothe@dwd.de}

Other contributors:
\itemize{
  \item Danny Parsons \email{danny@idems.international} [contributor]
}

}
\keyword{internal}
