% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_region_plot.R
\name{render_region_plot}
\alias{render_region_plot}
\title{Function to create a plot of a selected country.}
\usage{
render_region_plot(
  infile,
  outfile = NULL,
  fileExtension = ".png",
  visualizeVariables,
  visualizeDataMax,
  lon_bounds,
  lat_bounds,
  lon_loc_vec,
  lat_loc_vec,
  name_loc_vec,
  division,
  selectedRegion,
  region_data,
  timestep,
  num_tick,
  num_rmin,
  num_rmax,
  location,
  text1,
  text2,
  text3,
  PAL,
  palettes,
  num_brk,
  reverse,
  textsize,
  bordercolor,
  plot_grid,
  grid_col,
  image_def,
  ihsf,
  nc = NULL
)
}
\arguments{
\item{infile}{The nc file to be visualized.}

\item{outfile}{Name of the outfile (NULL or character). Should match the fileExtension.
If NULL is passed a file is created in the R session temporary directory.}

\item{fileExtension}{The file extension of the image (character). Has to be one of the following: 'png', 'jpg', 'tif', 'kml', 'pdf'.}

\item{visualizeVariables}{A data frame containing all meta data for the plotting process (data.frame).}

\item{visualizeDataMax}{Maximal data for computing breaks.}

\item{lon_bounds}{Array containing two values for longitude min and max (numeric).}

\item{lat_bounds}{Array containing two values for latitude min and max (numeric).}

\item{lon_loc_vec}{All longitude entries for points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{lat_loc_vec}{All latitude entries for points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{name_loc_vec}{Names for the points at (lat_loc_vec, lon_loc_vec) to be specified on the map (numeric).}

\item{division}{Division to contain region (either 'COUNTRY' or something coherent to region_data).}

\item{selectedRegion}{The region to be cropped according to division. If \code{division == "COUNTRY"}, the country's \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}{3-character ISO code} should be used. Otherwise it has to fit to the passed region data.}

\item{region_data}{If Division is not 'COUNTRY' then region_data has to contain spatial data of the given division.}

\item{timestep}{Timestep to visualize at (character).}

\item{num_tick}{Number of ticks (numeric).}

\item{num_rmin}{Color scale range minimum (numeric).}

\item{num_rmax}{Color scale range maximium (numeric).}

\item{location}{Whether points specified by (lat_loc_vec, lon_loc_vec, name_loc_vec) should be added to the map (logical).}

\item{text1}{Title text (character).}

\item{text2}{Text to be passed to graphics::mtext (character).}

\item{text3}{Text to be added to the legend (character).}

\item{PAL}{Color palette.}

\item{palettes}{Color palettes to be used.}

\item{num_brk}{Number of breaks (numeric).}

\item{reverse}{Whether to revert the color palette (logical).}

\item{textsize}{Textsize to be used (cex).}

\item{bordercolor}{Color used for borders.}

\item{plot_grid}{Whether to plot a grid using color grid_col (logical).}

\item{grid_col}{Color used for the grid.}

\item{image_def}{Default size (positive numeric).}

\item{ihsf}{Image height scaling factor (positive numeric).}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\description{
This function generates a plot of within a certain region (e.g. a country).
}
