% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_ignore_singletons.R
\name{feat_ignore_singletons}
\alias{feat_ignore_singletons}
\title{Feature: Ignore Singletons}
\usage{
feat_ignore_singletons(locus_group = "all")
}
\arguments{
\item{locus_group}{The loci for which this features is used. Can either be
\code{"all"} (default), in which case the feature is used for simulating
all loci, or a numeric vector. In the latter case, the feature is only
used for the loci added in \code{locus_} commands  with the corresponding
index starting from 1 in order in which the commands where added to the
model. For example, if a model has
\code{locus_single(10) + locus_averaged(10, 11) + locus_single(12)} and
this argument is \code{c(2, 3)}, than the feature is used for all but
the first locus (that is locus 2 - 12).}
}
\value{
The feature, which can be added to a model created with
  \code{\link{coal_model}} using \code{+}.
}
\description{
Mutations that are observed in just one haplotype ('singletons') are often
regarded as likely candidates for sequencing errors. Sometimes, it can be
advantageous to exclude them from an analysis. This feature removes all
singletons from the simulated data before the summary statistics are
calculated.
}
\details{
This function assumes that a singleton is a mutation for which the derived
allele is observed exactly once in all sequences, regardless of the
population structure.
}
\examples{
model <- coal_model(2, 1) +
  feat_mutation(10) +
  feat_ignore_singletons() +
  sumstat_sfs("n_mut", transformation = sum)
# In this model, all mutations are singletons. Therefore,
# the number of mutations is 0 when removing singletons:
simulate(model)$n_mut
}
\seealso{
For creating a model: \code{\link{coal_model}}

Other features: 
\code{\link{feat_growth}()},
\code{\link{feat_migration}()},
\code{\link{feat_mutation}()},
\code{\link{feat_outgroup}()},
\code{\link{feat_pop_merge}()},
\code{\link{feat_recombination}()},
\code{\link{feat_selection}()},
\code{\link{feat_size_change}()},
\code{\link{feat_unphased}()}
}
\concept{features}
