% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_attributes.R
\name{zap_attributes}
\alias{zap_attributes}
\title{Zap attributes}
\usage{
zap_attributes(x, attributes = c("format.spss", "format.sas", "format.stata",
  "label", "labels", "na_values", "na_range", "display_width"))
}
\arguments{
\item{x}{the data frame or variable}

\item{attributes}{character vector of attributes to zap. NULL if everything
(including factor levels etc) should be zapped}
}
\description{
Modelled on \code{\link[haven:zap_labels]{haven::zap_labels()}}, but more encompassing. By default removes
the following attributes:
format.spss, format.sas, format.stata, label, labels, na_values, na_range,
display_width
}
\examples{
bfi <- data.frame(matrix(data = rnorm(300), ncol = 3))
names(bfi) <- c("bfi_e1", "bfi_e2R", "bfi_e3")
attributes(bfi$bfi_e1)$label <- "I am outgoing."
attributes(bfi$bfi_e2R)$label <- "I prefer books to people."
attributes(bfi$bfi_e3)$label <- "I love to party."
bfi$bfi_e <- rowMeans(bfi[, c("bfi_e1", "bfi_e2R", "bfi_e3")])
bfi <- detect_scales(bfi, quiet = TRUE) # create attributes
str(zap_attributes(bfi, "label"))
zap_attributes(bfi$bfi_e)
}
