% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCoef.r
\name{extract.coef.xgb.Booster}
\alias{extract.coef.xgb.Booster}
\title{extract.coef.xgb.Booster}
\usage{
\method{extract.coef}{xgb.Booster}(model, feature_names = NULL, ...)
}
\arguments{
\item{model}{Model object from which to extract information.}

\item{feature_names}{Names of coefficients}

\item{\dots}{Further arguments}
}
\value{
A \code{\link{data.frame}} containing the coefficient, the standard error and the variable name.
}
\description{
Extract Coefficient Information from Models
}
\details{
Gets the coefficient values and variable names from a model.  Since xgboost does not have standard errors, those will just be NA.
}
\examples{
library(xgboost)
data(diamonds, package='ggplot2')
diaX <- useful::build.x(price ~ carat + cut + x, data=diamonds, contrasts=FALSE)
diaY <- useful::build.y(price ~ carat + cut + x, data=diamonds)
xg1 <- xgboost(data=diaX, label=diaY, 
booster='gblinear',
objective='reg:linear', eval_metric='rmse',
nrounds=50
)
extract.coef(xg1)
extract.coef(xg1, feature_names=colnames(diaX))

}
\author{
Jared P. Lander
}
