# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

dcoga2dim_nv <- function(x, shape1, shape2, rate1, rate2) {
    .Call('coga_dcoga2dim_nv', PACKAGE = 'coga', x, shape1, shape2, rate1, rate2)
}

#' Convolution of Two Gamma Distributions.
#'
#' Density, and distribution function of convolution of two gamma
#' distributions is a special situation of convolution of gamma
#' distributions. Compare to the general situation, the speed of code
#' is much faster. The algorithm of these two functions comes from
#' Mathai, A.M. (1982).
#'
#' @param x Quantiles.
#' @param shape1,shape2 Shape parameters of the first and second gamma
#' distributions, all shape parameters >= 0, at least one shape parameter > 0.
#' @param rate1,rate2 Rate parameters of the first and second gamma
#' distributions, all rate parameters > 0.
#'
#' @references
#' Mathai, A.M.: Storage capacity of a dam with gamma type inputs.
#' Ann. Inst. Statist.Math. 34, 591-597 (1982)
#'
#' @examples
#' ## do grid
#' y <- rcoga(100000, c(3,4), c(2,3))
#' grid <- seq(0, 15, length.out=100)
#' ## calculate pdf and cdf
#' pdf <- dcoga2dim(grid, 3, 4, 2, 3)
#' cdf <- pcoga2dim(grid, 3, 4, 2, 3)
#'
#' ## plot pdf
#' plot(density(y), col="blue")
#' lines(grid, pdf, col="red")
#'
#' ## plot cdf
#' plot(ecdf(y), col="blue")
#' lines(grid, cdf, col="red")
#'
#' @author Chaoran Hu
#'
#' @export
dcoga2dim <- function(x, shape1, shape2, rate1, rate2) {
    .Call('coga_dcoga2dim', PACKAGE = 'coga', x, shape1, shape2, rate1, rate2)
}

pcoga2dim_nv <- function(x, shape1, shape2, rate1, rate2) {
    .Call('coga_pcoga2dim_nv', PACKAGE = 'coga', x, shape1, shape2, rate1, rate2)
}

#' @rdname dcoga2dim
#' @export
pcoga2dim <- function(x, shape1, shape2, rate1, rate2) {
    .Call('coga_pcoga2dim', PACKAGE = 'coga', x, shape1, shape2, rate1, rate2)
}

#' Recurrence Identity of Shape Parameter for Distribution Function of coga2dim 
#'
#' The difference of distribution functions of convolution of two gamma
#' distributions between consecutive neighbors of shape parameter. This
#' function can return the value of pcoga2dim(x, shape1, shape2, rate1, rate2)
#' - pcoga2dim(x, shape1 + 1, shape2, rate1, rate2) with higher efficiency
#' (this function is much more faster than call pcoga2dim).
#'
#' @param x Quantiles.
#' @param shape1,shape2 Shape parameters of the first and second gamma
#' distributions, all shape parameters >= 0.
#' @param rate1,rate2 Rate parameters of the first and second gamma
#' distributions, all rate parameters > 0.
#'
#' @examples
#' pcoga2dim_diff_shape(3,2,4,5,4)
#' pcoga2dim(3,2,4,5,4) - pcoga2dim(3,3,4,5,4)
#'
#' pcoga2dim_diff_shape(3,0,4,3,5)
#' pgamma(3,4,5) - pcoga2dim(3,1,4,3,5)
#'
#' pcoga2dim_diff_shape(3,6,0,5,4)
#' pgamma(3,6,5) - pgamma(3,7,5)
#'
#' pcoga2dim_diff_shape(3,0,0,4,5)
#' 1 - pgamma(3,1,4)
#'
#' @author Chaoran Hu
#'
#' @export
pcoga2dim_diff_shape <- function(x, shape1, shape2, rate1, rate2) {
    .Call('coga_pcoga2dim_diff_shape', PACKAGE = 'coga', x, shape1, shape2, rate1, rate2)
}

#' Convolution of Gamma Distributions.
#'
#' Density, distribution function, and random generation for convolution of gamma
#' distributions. The distribution of the convolution of independent Gamma random
#' variables with different parameters
#' is \eqn{Y = X_{1} + ... + X_{n}}, where \eqn{X_{i}, i = 1, ..., n},
#' are independent Gamma distributions with parameters shapes and rates.
#' The density function and distribution function can be calculated, according to the
#' formulas from Moschopoulos, Peter G. (1985).
#'
#' @param x Quantiles.
#' @param n Number of sample.
#' @param shape Numerical vector of shape parameters of every gamma distributions,
#' all shape parameters >= 0, at least one shape parameter > 0.
#' @param rate Numerical vector of rate parameters of every gamma distributions,
#' all rate parameters > 0.
#'
#' @references
#' Moschopoulos, Peter G. "The distribution of the sum of independent
#' gamma random variables." Annals of the Institute of
#' Statistical Mathematics 37.1 (1985): 541-544.
#' @examples
#' set.seed(123)
#' ## do grid
#' y <- rcoga(100000, c(3,4,5), c(2,3,4))
#' grid <- seq(0, 15, length.out=100)
#' ## calculate pdf and cdf
#' pdf <- dcoga(grid, shape=c(3,4,5), rate=c(2,3,4))
#' cdf <- pcoga(grid, shape=c(3,4,5), rate=c(2,3,4))
#'
#' ## plot pdf
#' plot(density(y), col="blue")
#' lines(grid, pdf, col="red")
#'
#' ## plot cdf
#' plot(ecdf(y), col="blue")
#' lines(grid, cdf, col="red")
#'
#' @author Chaoran Hu
#'
#' @export
dcoga <- function(x, shape, rate) {
    .Call('coga_dcoga', PACKAGE = 'coga', x, shape, rate)
}

#' @rdname dcoga
#' @export
pcoga <- function(x, shape, rate) {
    .Call('coga_pcoga', PACKAGE = 'coga', x, shape, rate)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('coga_RcppExport_registerCCallable', PACKAGE = 'coga')
})
