context("fmode")

x <- rnorm(100)
w <- abs(100*rnorm(100))
xNA <- x
wNA <- w
xNA[sample.int(100,20)] <- NA
wNA[sample.int(100,20)] <- NA
f <- as.factor(sample.int(10, 100, TRUE))

data <- wlddev[wlddev$iso3c %in% c("BLZ","IND","USA","SRB","GRL"), ]
l <- nrow(data)
g <- GRP(droplevels(data$iso3c))
dataNA <- na_insert(data)
m <- as.matrix(data)
mNA <- as.matrix(dataNA)
wdat <- abs(100*rnorm(l))
wdatNA <- wdat
wdatNA[sample.int(l, floor(l/5))] <- NA

# seteltNA <- function(x,i,j) {
#   x[i,j] <- NA
#   x
# }

Mode <- function(x, na.rm = FALSE) {
  if(na.rm) x <- x[!is.na(x)]
  ux <- unique(x)
  ux[which.max(tabulate(match(x, ux)))]
}

weighted.Mode <- function(x, w, na.rm = FALSE) {
  ax <- attributes(x)
  if(na.rm) {
    cc <- complete.cases(x, w)
    w <- w[cc]
    x <- x[cc]
  }
  sw <- fsum.default(w, x)
  max <- which.max(sw)
  res <- names(sw)[max]
  storage.mode(res) <- storage.mode(x)
  `attributes<-`(res, ax)
}

test_that("fmode performs like Mode (defined above)", {
  expect_equal(fmode(NA), Mode(NA))
  expect_equal(fmode(NA, na.rm = FALSE), Mode(NA))
  expect_equal(fmode(1), Mode(1, na.rm = TRUE))
  expect_equal(fmode(1:3), Mode(1:3, na.rm = TRUE))
  expect_equal(fmode(-1:1), Mode(-1:1, na.rm = TRUE))
  expect_equal(fmode(1, na.rm = FALSE), Mode(1))
  expect_equal(fmode(1:3, na.rm = FALSE), Mode(1:3))
  expect_equal(fmode(-1:1, na.rm = FALSE), Mode(-1:1))
  expect_equal(fmode(x), Mode(x, na.rm = TRUE))
  expect_equal(fmode(x, na.rm = FALSE), Mode(x))
  expect_equal(fmode(xNA, na.rm = FALSE), Mode(xNA))
  expect_equal(fmode(xNA), Mode(xNA, na.rm = TRUE))
  # expect_equal(as.character(fmode(data, drop = FALSE)), fmode(m))
  expect_equal(fmode(m), dapply(m, Mode, na.rm = TRUE))
  expect_equal(fmode(m, na.rm = FALSE), dapply(m, Mode))
  expect_equal(fmode(mNA, na.rm = FALSE), dapply(mNA, Mode))
  expect_equal(fmode(mNA), dapply(mNA, Mode, na.rm = TRUE))
  expect_equal(fmode(x, f), BY(x, f, Mode, na.rm = TRUE))
  expect_equal(fmode(x, f, na.rm = FALSE), BY(x, f, Mode))
  expect_equal(fmode(xNA, f, na.rm = FALSE), BY(xNA, f, Mode))
  expect_equal(fmode(xNA, f), BY(xNA, f, Mode, na.rm = TRUE))
  expect_equal(fmode(m, g), BY(m, g, Mode, na.rm = TRUE))
  expect_equal(fmode(m, g, na.rm = FALSE), BY(m, g, Mode))
  # expect_equal(seteltNA(fmode(mNA, g, na.rm = FALSE),4,5), seteltNA(BY(mNA, g, Mode),4,5)) # Mode gives NA
  expect_equal(fmode(mNA, g), BY(mNA, g, Mode, na.rm = TRUE))
  expect_equal(fmode(data, g), BY(data, g, Mode, na.rm = TRUE))
  expect_equal(fmode(data, g, na.rm = FALSE), BY(data, g, Mode))
  # expect_equal(seteltNA(fmode(dataNA, g, na.rm = FALSE),4,5), seteltNA(BY(dataNA, g, Mode),4,5))  # Mode gives NA
  expect_equal(fmode(dataNA, g), BY(dataNA, g, Mode, na.rm = TRUE))
})

test_that("fmode with weights performs as intended (unbiased)", {
  expect_equal(fmode(c(2,2,4,5,5,5)), fmode(c(2,4,5), w = c(2,1,3)))
  expect_equal(fmode(c(2,2,4,5,5,5), na.rm = FALSE), fmode(c(2,4,5), w = c(2,1,3), na.rm = FALSE))
  expect_equal(fmode(c(2.456,2.456,4.123,5.009,5.009,5.009)), fmode(c(2.456,4.123,5.009), w = c(2,1,3)))
  expect_equal(fmode(c(2.456,2.456,4.123,5.009,5.009,5.009), na.rm = FALSE), fmode(c(2.456,4.123,5.009), w = c(2,1,3), na.rm = FALSE))
  expect_equal(fmode(c(2,2,NA,5,5,5)), fmode(c(2,NA,5), w = c(2,1,3)))
  expect_equal(fmode(c(2,2,NA,5,5,5), na.rm = FALSE), fmode(c(2,NA,5), w = c(2,1,3), na.rm = FALSE))
  expect_equal(fmode(c(2,2,NA,5,5,5)), fmode(c(2,4,5), w = c(2,NA,3)))
  expect_equal(fmode(c(2,2,NA,5,5,5), na.rm = FALSE), fmode(c(2,4,5), w = c(2,NA,3), na.rm = FALSE))
  expect_equal(fmode(c(NA,NA,4.123,5.009,5.009,5.009)), fmode(c(NA,4.123,5.009), w = c(2,1,3)))
  expect_equal(fmode(c(NA,NA,4.123,5.009,5.009,5.009), na.rm = FALSE), fmode(c(NA,4.123,5.009), w = c(2,1,3), na.rm = FALSE))
  expect_equal(fmode(c(NA,NA,4.123,5.009,5.009,5.009)), fmode(c(2.456,4.123,5.009), w = c(NA,1,3)))
  expect_equal(fmode(c(NA,NA,4.123,5.009,5.009,5.009), na.rm = FALSE), fmode(c(2.456,4.123,5.009), w = c(NA,1,3), na.rm = FALSE))
  f <- as.factor(rep(1:2, each = 6)); fs <- as.factor(rep(1:2, each = 3))
  v <- c(2,2,4,5,5,5,2,2,4,5,5,5); vs <- c(2,4,5,2,4,5); w <- c(2,1,3,2,1,3)
  v2 <- c(2.456,2.456,4.123,5.009,5.009,5.009,2.456,2.456,4.123,5.009,5.009,5.009); v2s <- c(2.456,4.123,5.009,2.456,4.123,5.009)
  expect_equal(fmode(v, f), fmode(vs, fs, w))
  expect_equal(fmode(v, f, na.rm = FALSE), fmode(vs, fs, w, na.rm = FALSE))
  expect_equal(fmode(v2, f), fmode(v2s, fs, w))
  expect_equal(fmode(v2, f, na.rm = FALSE), fmode(v2s, fs, w, na.rm = FALSE))
  v[c(3,9)] <- NA; vs[c(2,5)] <- NA
  expect_equal(fmode(v, f), fmode(vs, fs, w))
  expect_equal(fmode(v, f, na.rm = FALSE), fmode(vs, fs, w, na.rm = FALSE))
  vs[c(2,5)] <- 4; w[c(2,5)] <- NA
  expect_equal(fmode(v, f), fmode(vs, fs, w))
  expect_equal(fmode(v, f, na.rm = FALSE), fmode(vs, fs, w, na.rm = FALSE))
  w[c(2,5)] <- 1; v2[c(1:2,7:8)] <- NA; v2s[c(1,4)] <- NA
  expect_equal(fmode(v2, f), fmode(v2s, fs, w))
  expect_equal(fmode(v2, f, na.rm = FALSE), fmode(v2s, fs, w, na.rm = FALSE))
  v2s[c(1,4)] <- 2.456; w[c(1,4)] <- NA
  expect_equal(fmode(v2, f), fmode(v2s, fs, w))
  expect_equal(fmode(v2, f, na.rm = FALSE), fmode(v2s, fs, w, na.rm = FALSE))
})

test_that("fmode performs like fmode with weights all equal", {
  expect_equal(fmode(NA), fmode(NA, w = 0.99999999))
  expect_equal(fmode(NA, na.rm = FALSE), fmode(NA, w = 2.946, na.rm = FALSE))
  expect_equal(fmode(1), fmode(1, w = 3))
  expect_equal(fmode(1:3), fmode(1:3, w = rep(0.999,3)))
  expect_equal(fmode(-1:1), fmode(-1:1, w = rep(4.2,3)))
  expect_equal(fmode(1, na.rm = FALSE), fmode(1, w = 5, na.rm = FALSE))
  expect_equal(fmode(1:3, na.rm = FALSE), fmode(1:3, w = rep(1.44565, 3), na.rm = FALSE))
  expect_equal(fmode(-1:1, na.rm = FALSE), fmode(-1:1, w = rep(1.44565, 3), na.rm = FALSE))
  expect_equal(fmode(x), fmode(x, w = rep(1,100)))
  expect_equal(fmode(x, na.rm = FALSE), fmode(x, w = rep(1.44565, 100), na.rm = FALSE))
  expect_equal(fmode(xNA, na.rm = FALSE), fmode(xNA, w = rep(4.676587, 100), na.rm = FALSE))
  expect_equal(fmode(xNA), fmode(xNA, w = rep(4.676587, 100)))
  expect_equal(fmode(m), fmode(m, w = rep(6587, l)))
  expect_equal(fmode(m, na.rm = FALSE), fmode(m, w = rep(6587, l), na.rm = FALSE))
  expect_equal(fmode(mNA, na.rm = FALSE), fmode(mNA, w = rep(6587, l), na.rm = FALSE))
  expect_equal(fmode(mNA), fmode(mNA, w = rep(6587, l)))
  expect_equal(fmode(data), fmode(data, w = rep(6787, l)))
  expect_equal(fmode(data, na.rm = FALSE), fmode(data, w = rep(6787, l), na.rm = FALSE))
  expect_equal(fmode(dataNA, na.rm = FALSE), fmode(dataNA, w = rep(6787, l), na.rm = FALSE))
  expect_equal(fmode(dataNA), fmode(dataNA, w = rep(6787, l)))
  expect_equal(fmode(x, f), fmode(x, f, rep(546,100)))
  expect_equal(fmode(x, f, na.rm = FALSE), fmode(x, f, rep(5.88,100), na.rm = FALSE))
  expect_equal(fmode(xNA, f, na.rm = FALSE), fmode(xNA, f, rep(52.7,100), na.rm = FALSE))
  expect_equal(fmode(xNA, f), fmode(xNA, f, rep(5997456,100)))
  expect_equal(fmode(m, g), fmode(m, g, rep(546,l)))
  expect_equal(fmode(m, g, na.rm = FALSE), fmode(m, g, rep(0.0001,l), na.rm = FALSE))
  expect_equal(fmode(mNA, g, na.rm = FALSE), fmode(mNA, g, rep(5.7,l), na.rm = FALSE))
  expect_equal(fmode(mNA, g), fmode(mNA, g, rep(1,l)))
  expect_equal(fmode(data, g), fmode(data, g, rep(53,l)))
  expect_equal(fmode(data, g, na.rm = FALSE), fmode(data, g, rep(546,l), na.rm = FALSE))
  expect_equal(fmode(dataNA, g, na.rm = FALSE), fmode(dataNA, g, rep(0.9,l), na.rm = FALSE)) # rep(0.999999,l) failed CRAN Arch i386
  expect_equal(fmode(dataNA, g), fmode(dataNA, g, rep(999,l))) # rep(999.9999,l) failed CRAN Arch i386
})

test_that("fmode with weights performs like weighted.Mode (defined above)", {
  # complete weights
  # expect_equal(fmode(NA, w = 1), weighted.Mode(NA, 1))
  # expect_equal(fmode(NA, w = 1, na.rm = FALSE), weighted.Mode(NA, 1))
  expect_equal(fmode(1, w = 1), weighted.Mode(1, w = 1))
  expect_equal(fmode(1:3, w = 1:3), weighted.Mode(1:3, 1:3))
  expect_equal(fmode(-1:1, w = 1:3), weighted.Mode(-1:1, 1:3))
  expect_equal(fmode(1, w = 1, na.rm = FALSE), weighted.Mode(1, 1))
  expect_equal(fmode(1:3, w = c(0.99,3454,1.111), na.rm = FALSE), weighted.Mode(1:3, c(0.99,3454,1.111)))
  expect_equal(fmode(-1:1, w = 1:3, na.rm = FALSE), weighted.Mode(-1:1, 1:3))
  expect_equal(fmode(x, w = w), weighted.Mode(x, w))
  expect_equal(fmode(x, w = w, na.rm = FALSE), weighted.Mode(x, w))
  expect_equal(fmode(xNA, w = w, na.rm = FALSE), weighted.Mode(xNA, w))
  expect_equal(fmode(xNA, w = w), weighted.Mode(xNA, w, na.rm = TRUE))
  # expect_equal(fmode(data, w = wdat, drop = FALSE), fmode(m, w = wdat))
  expect_equal(fmode(m, w = wdat), dapply(m, weighted.Mode, wdat, na.rm = TRUE))
  expect_equal(fmode(m, w = wdat, na.rm = FALSE), dapply(m, weighted.Mode, wdat))
  expect_equal(fmode(mNA, w = wdat, na.rm = FALSE), dapply(mNA, weighted.Mode, wdat))
  expect_equal(fmode(mNA, w = wdat), dapply(mNA, weighted.Mode, wdat, na.rm = TRUE))
  expect_equal(fmode(x, f, w), mapply(weighted.Mode, split(x, f), split(w, f)))
  expect_equal(fmode(x, f, w, na.rm = FALSE), mapply(weighted.Mode, split(x, f), split(w, f)))
  expect_equal(fmode(xNA, f, w, na.rm = FALSE), mapply(weighted.Mode, split(xNA, f), split(w, f)))
  expect_equal(fmode(xNA, f, w), mapply(weighted.Mode, split(xNA, f), split(w, f), na.rm = TRUE))
  # missing weights
  # expect_equal(fmode(NA, w = NA), weighted.Mode(NA, NA))
  # expect_equal(fmode(NA, w = NA, na.rm = FALSE), weighted.Mode(NA, NA))
  # expect_equal(fmode(1, w = NA), weighted.Mode(1, w = NA))
  expect_equal(fmode(1:3, w = c(NA,1:2)), weighted.Mode(1:3, c(NA,1:2), na.rm = TRUE)) # weighted Mode doesn not remove NA's from weights !!
  expect_equal(fmode(-1:1, w = c(NA,1:2)), weighted.Mode(-1:1, c(NA,1:2), na.rm = TRUE))
  # expect_equal(fmode(1, w = NA, na.rm = FALSE), weighted.Mode(1, NA))
  expect_equal(fmode(1:3, w = c(NA,1:2), na.rm = FALSE), weighted.Mode(1:3, c(NA,1:2)))
  expect_equal(fmode(-1:1, w = c(NA,1:2), na.rm = FALSE), weighted.Mode(-1:1, c(NA,1:2)))
  expect_equal(fmode(x, w = wNA), weighted.Mode(x, wNA, na.rm = TRUE))
  expect_equal(fmode(x, w = wNA, na.rm = FALSE), weighted.Mode(x, wNA)) #
  # expect_equal(fmode(xNA, w = wNA, na.rm = FALSE), weighted.Mode(xNA, wNA))
  expect_equal(fmode(xNA, w = wNA), weighted.Mode(xNA, wNA, na.rm = TRUE))
  # expect_equal(fmode(data, w = wdatNA), fmode(m, w = wdatNA))
  expect_equal(fmode(m, w = wdatNA), dapply(m, weighted.Mode, wdatNA, na.rm = TRUE))
  # expect_equal(fmode(m, w = wdatNA, na.rm = FALSE), dapply(m, weighted.Mode, wdatNA))
  # expect_equal(fmode(mNA, w = wdatNA, na.rm = FALSE), dapply(mNA, weighted.Mode, wdatNA))
  expect_equal(fmode(mNA, w = wdatNA), dapply(mNA, weighted.Mode, wdatNA, na.rm = TRUE))
  expect_equal(fmode(x, f, wNA), mapply(weighted.Mode, split(x, f), split(wNA, f), na.rm = TRUE))
  expect_equal(fmode(x, f, wNA, na.rm = FALSE), mapply(weighted.Mode, split(x, f), split(wNA, f)))
  # expect_equal(fmode(xNA, f, wNA, na.rm = FALSE), mapply(weighted.Mode, split(xNA, f), split(wNA, f)))
  expect_equal(fmode(xNA, f, wNA), mapply(weighted.Mode, split(xNA, f), split(wNA, f), na.rm = TRUE))
})

test_that("fmode performs numerically stable", {
  expect_true(all_obj_equal(replicate(50, fmode(1), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(NA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(NA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, f), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, f, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, f, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, f), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, g), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, g), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, g), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, g, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, g), simplify = FALSE)))
})

test_that("fmode with complete weights performs numerically stable", {
  expect_true(all_obj_equal(replicate(50, fmode(1, w = 1), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(NA, w = 1), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(NA, w = 1, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, w = w), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, w = w, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, w = w, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, w = w), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, w = wdat), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, w = wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, w = wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, w = wdat), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, w = wdat), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, w = wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, w = wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, w = wdat), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, f, w), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, f, w, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, f, w, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, f, w), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, g, wdat), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, g, wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, g, wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, g, wdat), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, g, wdat), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, g, wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, g, wdat, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, g, wdat), simplify = FALSE)))
})

test_that("fmode with missing weights performs numerically stable", {
  expect_true(all_obj_equal(replicate(50, fmode(1, w = NA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(NA, w = NA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(NA, w = NA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, w = wNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, w = wNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, w = wNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, w = wNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, w = wdatNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, w = wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, w = wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, w = wdatNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, w = wdatNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, w = wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, w = wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, w = wdatNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, f, wNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(x, f, wNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, f, wNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(xNA, f, wNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, g, wdatNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(m, g, wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, g, wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(mNA, g, wdatNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, g, wdatNA), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(data, g, wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, g, wdatNA, na.rm = FALSE), simplify = FALSE)))
  expect_true(all_obj_equal(replicate(50, fmode(dataNA, g, wdatNA), simplify = FALSE)))
})

test_that("fmode handles special values in the right way", {
  expect_equal(fmode(NA), NA)
  expect_equal(fmode(NaN), NaN)
  expect_equal(fmode(Inf), Inf)
  expect_equal(fmode(-Inf), -Inf)
  expect_equal(fmode(TRUE), TRUE)
  expect_equal(fmode(FALSE), FALSE)
  expect_equal(fmode(NA, na.rm = FALSE), NA)
  expect_equal(fmode(NaN, na.rm = FALSE), NaN)
  expect_equal(fmode(Inf, na.rm = FALSE), Inf)
  expect_equal(fmode(-Inf, na.rm = FALSE), -Inf)
  expect_equal(fmode(TRUE, na.rm = FALSE), TRUE)
  expect_equal(fmode(FALSE, na.rm = FALSE), FALSE)
  expect_equal(fmode(c(1,NA)), 1)
  expect_equal(fmode(c(1,NaN)), 1)
  expect_equal(fmode(c(1,Inf)), 1)
  expect_equal(fmode(c(1,-Inf)), 1)
  expect_equal(fmode(c(FALSE,TRUE)), TRUE) # ???????
  expect_equal(fmode(c(FALSE,FALSE)), FALSE)
  expect_equal(fmode(c(1,Inf), na.rm = FALSE), 1)
  expect_equal(fmode(c(1,-Inf), na.rm = FALSE), 1)
  expect_equal(fmode(c(FALSE,TRUE), na.rm = FALSE), TRUE) # ??????
  expect_equal(fmode(c(FALSE,FALSE), na.rm = FALSE), FALSE)
})

test_that("fmode with weights handles special values in the right way", {
  expect_equal(fmode(NA, w = 1), NA)
  expect_equal(fmode(NaN, w = 1), NaN)
  expect_equal(fmode(Inf, w = 1), Inf)
  expect_equal(fmode(-Inf, w = 1), -Inf)
  expect_equal(fmode(TRUE, w = 1), TRUE)
  expect_equal(fmode(FALSE, w = 1), FALSE)
  expect_equal(fmode(NA, w = 1, na.rm = FALSE), NA)
  expect_equal(fmode(NaN, w = 1, na.rm = FALSE), NaN)
  expect_equal(fmode(Inf, w = 1, na.rm = FALSE), Inf)
  expect_equal(fmode(-Inf, w = 1, na.rm = FALSE), -Inf)
  expect_equal(fmode(TRUE, w = 1, na.rm = FALSE), TRUE)
  expect_equal(fmode(FALSE, w = 1, na.rm = FALSE), FALSE)
  expect_equal(fmode(NA, w = NA), NA)
  expect_equal(fmode(NaN, w = NA), NaN)
  expect_equal(fmode(Inf, w = NA), Inf)
  expect_equal(fmode(-Inf, w = NA), -Inf)
  # expect_equal(fmode(TRUE, w = NA), TRUE) # ????
  # expect_equal(fmode(FALSE, w = NA), FALSE) # ????
  # expect_equal(fmode(NA, w = NA, na.rm = FALSE), NA) # ????
  expect_equal(fmode(NaN, w = NA, na.rm = FALSE), NaN)
  expect_equal(fmode(Inf, w = NA, na.rm = FALSE), Inf)
  expect_equal(fmode(-Inf, w = NA, na.rm = FALSE), -Inf)
  expect_equal(fmode(TRUE, w = NA, na.rm = FALSE), TRUE)
  # expect_equal(fmode(FALSE, w = NA, na.rm = FALSE), FALSE) # ????
  expect_equal(fmode(1:3, w = c(1,Inf,3)), 2)
  expect_equal(fmode(1:3, w = c(1,-Inf,3)), 3)
  expect_equal(fmode(1:3, w = c(1,Inf,3), na.rm = FALSE), 2)
  expect_equal(fmode(1:3, w = c(1,-Inf,3), na.rm = FALSE), 3)
})

test_that("fmode produces errors for wrong input", {
  expect_visible(fmode("a"))
  expect_visible(fmode(NA_character_))
  expect_visible(fmode(mNA))
  expect_error(fmode(mNA, f))
  expect_error(fmode(1:2,1:3))
  expect_error(fmode(m,1:31))
  expect_error(fmode(data,1:31))
  expect_visible(fmode("a", w = 1))
  expect_error(fmode(1:2, w = 1:3))
  expect_visible(fmode(NA_character_, w = 1))
  expect_visible(fmode(mNA, w = wdat))
  expect_error(fmode(mNA, f, wdat))
  expect_error(fmode(mNA, w = 1:33))
  expect_error(fmode(1:2,1:2, 1:3))
  expect_error(fmode(m,1:32,1:20))
  expect_error(fmode(data,1:32,1:10))
  expect_error(fmode(1:2, w = c("a","b")))
  expect_visible(fmode(wlddev))
  expect_visible(fmode(wlddev, w = wlddev$year, drop = FALSE))
  expect_visible(fmode(wlddev, wlddev$iso3c))
  expect_visible(fmode(wlddev, wlddev$iso3c, wlddev$year))
})


