% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collisions.R
\name{CRAN_collisions}
\alias{CRAN_collisions}
\title{Check for Namespace Collisions}
\usage{
CRAN_collisions(function_or_package_name)
}
\arguments{
\item{function_or_package_name}{A character string, or vector of character strings.}
}
\description{
Check for namespace collisions with functions and packages on CRAN
}
\examples{

# Test single function name
function_or_package_name <- "a3.r2"
CRAN_collisions(function_or_package_name)

# Test multiple function names
function_or_package_name <- c("a3.r2", "xtable.A3")
CRAN_collisions(function_or_package_name)

# Test single package name
function_or_package_name <- "dplyr"
CRAN_collisions(function_or_package_name)

# Test multiple package names
function_or_package_name <- c("dplyr", "data.frame", "gsubfn")
CRAN_collisions(function_or_package_name)



}
