% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_metrics.R
\name{chisqDistance}
\alias{chisqDistance}
\title{Chi-square distance between vectors}
\usage{
chisqDistance(a, b)
}
\arguments{
\item{a}{Numeric vector.}

\item{b}{Numeric vector; must be the same length as a.}
}
\value{
Chi-squared distance, \eqn{(a - b)^2/(a + b)}, between vectors a and
  b. If one or both elements are NA/NaN, contribution is counted as a 0.
}
\description{
Computes the chi-squared distance between each element of a pair of vectors
which must be of the same length. Good for comparing color histograms if you
don't want to weight by color similarity. Probably hugely redundant; alas.
}
\examples{
colordistance:::chisqDistance(rnorm(10), rnorm(10))
}
