% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wecove.R
\name{get_wecove}
\alias{get_wecove}
\title{Create a weighted co-occurrence vector (wecove)}
\usage{
get_wecove(x, ordered = TRUE)
}
\arguments{
\item{x}{A matrix - an output of the \code{\link[=get_wecoma]{get_wecoma()}} function}

\item{ordered}{The type of pairs considered.
Either ordered (TRUE) or unordered (FALSE).
The default is TRUE.}
}
\value{
A weighted co-occurrence vector
}
\description{
Converts a weighted co-occurrence matrix (wecoma) to
a weighted co-occurrence vector (wecove)
}
\examples{
library(comat)
library(raster)
data(x, package = "comat")
data(w, package = "comat")

wom = get_wecoma(x, w)
wom

wov = get_wecove(wom)
wov
}
