% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icartes.R
\name{icartes}
\alias{icartes}
\alias{icartesv}
\title{Cartesian Product Iterator}
\usage{
icartes(nvec)

icartesv(...)
}
\arguments{
\item{nvec}{integer vector of number of items}

\item{...}{set of iterables (subsettable by \code{[})}
}
\value{
iterator object
}
\description{
Create an iterator going through Cartesian product of several items.
}
\details{
\itemize{
\item{\code{icartes} iterates through all combinations of integers}
\item{\code{icartesv} iterates through all combinations of general values}
}
}
\examples{
x <- icartes(c(3, 2, 4))
ct <- 0
while (hasNext(x))
{
  ct <- ct + 1
  i <- nextElem(x)
  cat(sprintf("\%3d : \%s\\n", ct, paste0(i, collapse = " ")))
}

x <- icartesv(Month=c("Jan", "Feb", "Mar"),
              Loc=c("NY", "LA"),
              By=c("car", "plane", "bus"))
as.list(x)
}
