% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-methods.R
\name{create_project}
\alias{create_project}
\title{Create a project}
\usage{
create_project(
  project_name,
  project_description,
  public = FALSE,
  workspace_name = NULL,
  api_key = NULL
)
}
\arguments{
\item{project_name}{Project name.}

\item{project_description}{Project description.}

\item{public}{Whether the project should be public or private.}

\item{workspace_name}{Workspace name (can also be specified using the \code{COMET_WORKSPACE}
parameter as an environment variable or in a comet config file).}

\item{api_key}{Comet API key (can also be specified using the \code{COMET_API_KEY}
parameter as an environment variable or in a comet config file).}
}
\description{
Create a project
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE variables defined
create_project(project_name = "project1", project_description = "My first project")
}

}
