% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{Experiment}
\alias{Experiment}
\title{A Comet Experiment object}
\value{
\code{\link{LoggedArtifact}} with all relevant information about logged
artifact.

\code{\link{LoggedArtifact}} with all relevant information about logged
artifact.
}
\description{
A comet experiment object can be used to modify or get information about an active
experiment. All methods documented here are the different ways to interact with an
experiment. Use \code{\link[=create_experiment]{create_experiment()}} to create or \code{\link[=get_experiment]{get_experiment()}} to
retrieve a Comet experiment object.
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables define
exp <- create_experiment()
exp$get_key()
exp$get_metadata()
exp$add_tags(c("test", "tag2"))
exp$get_tags()
exp$log_metric("metric1", 5)
exp$get_metric("metric1")
exp$get_metrics_summary()
exp$stop()
}


## ------------------------------------------------
## Method `Experiment$get_artifact`
## ------------------------------------------------

\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables define
exp <- create_experiment()

# Get a Comet Artifact
logged_artifact <- exp$get_artifact("workspace/artifact-name:version_or_alias")

# Which is equivalent to
logged_artifact = exp$get_artifact(artifact_name="artifact-name",
                                   workspace="workspace",
                                   version_or_alias="version_or_alias")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Experiment-new}{\code{Experiment$new()}}
\item \href{#method-Experiment-get_key}{\code{Experiment$get_key()}}
\item \href{#method-Experiment-get_workspace_name}{\code{Experiment$get_workspace_name()}}
\item \href{#method-Experiment-get_project_name}{\code{Experiment$get_project_name()}}
\item \href{#method-Experiment-get_dynamic}{\code{Experiment$get_dynamic()}}
\item \href{#method-Experiment-get_url}{\code{Experiment$get_url()}}
\item \href{#method-Experiment-get_metadata}{\code{Experiment$get_metadata()}}
\item \href{#method-Experiment-archive}{\code{Experiment$archive()}}
\item \href{#method-Experiment-restore}{\code{Experiment$restore()}}
\item \href{#method-Experiment-delete}{\code{Experiment$delete()}}
\item \href{#method-Experiment-stop}{\code{Experiment$stop()}}
\item \href{#method-Experiment-log_metric}{\code{Experiment$log_metric()}}
\item \href{#method-Experiment-get_metric}{\code{Experiment$get_metric()}}
\item \href{#method-Experiment-get_metrics_summary}{\code{Experiment$get_metrics_summary()}}
\item \href{#method-Experiment-log_graph}{\code{Experiment$log_graph()}}
\item \href{#method-Experiment-get_graph}{\code{Experiment$get_graph()}}
\item \href{#method-Experiment-log_parameter}{\code{Experiment$log_parameter()}}
\item \href{#method-Experiment-get_parameters}{\code{Experiment$get_parameters()}}
\item \href{#method-Experiment-log_other}{\code{Experiment$log_other()}}
\item \href{#method-Experiment-get_other}{\code{Experiment$get_other()}}
\item \href{#method-Experiment-add_tags}{\code{Experiment$add_tags()}}
\item \href{#method-Experiment-get_tags}{\code{Experiment$get_tags()}}
\item \href{#method-Experiment-log_html}{\code{Experiment$log_html()}}
\item \href{#method-Experiment-get_html}{\code{Experiment$get_html()}}
\item \href{#method-Experiment-upload_asset}{\code{Experiment$upload_asset()}}
\item \href{#method-Experiment-log_remote_asset}{\code{Experiment$log_remote_asset()}}
\item \href{#method-Experiment-get_asset_list}{\code{Experiment$get_asset_list()}}
\item \href{#method-Experiment-get_asset}{\code{Experiment$get_asset()}}
\item \href{#method-Experiment-create_symlink}{\code{Experiment$create_symlink()}}
\item \href{#method-Experiment-log_git_metadata}{\code{Experiment$log_git_metadata()}}
\item \href{#method-Experiment-get_git_metadata}{\code{Experiment$get_git_metadata()}}
\item \href{#method-Experiment-get_git_patch}{\code{Experiment$get_git_patch()}}
\item \href{#method-Experiment-get_output}{\code{Experiment$get_output()}}
\item \href{#method-Experiment-log_code}{\code{Experiment$log_code()}}
\item \href{#method-Experiment-get_code}{\code{Experiment$get_code()}}
\item \href{#method-Experiment-log_system_details}{\code{Experiment$log_system_details()}}
\item \href{#method-Experiment-get_system_details}{\code{Experiment$get_system_details()}}
\item \href{#method-Experiment-log_artifact}{\code{Experiment$log_artifact()}}
\item \href{#method-Experiment-get_artifact}{\code{Experiment$get_artifact()}}
\item \href{#method-Experiment-set_start_end_time}{\code{Experiment$set_start_end_time()}}
\item \href{#method-Experiment-print}{\code{Experiment$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-new"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-new}{}}}
\subsection{Method \code{new()}}{
Do not call this function directly. Use \code{create_experiment()} or \code{get_experiment()} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$new(
  experiment_key,
  experiment_url = NULL,
  api_key = NULL,
  keep_active = FALSE,
  log_output = FALSE,
  log_error = FALSE,
  dynamic = TRUE,
  workspace_name = NULL,
  project_name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{experiment_key}}{The key of the \code{Experiment}.}

\item{\code{experiment_url}}{The URL of the \code{Experiment}.}

\item{\code{api_key}}{Comet API key (can also be specified using the \code{COMET_API_KEY}
parameter as an environment variable or in a comet config file).}

\item{\code{keep_active}}{If \code{TRUE}, automatically send Comet a status update every
few seconds until the experiment is stopped to mark the experiment as active on the
Comet web dashboard.}

\item{\code{log_output}}{If \code{TRUE}, all standard output will automatically be sent to
the Comet servers to display as message logs for the experiment. The output will still
be shown in the console as well.}

\item{\code{log_error}}{If \code{TRUE}, all output from 'stderr' (which includes errors,
warnings, and messages) will be redirected to the Comet servers to display as message
logs for the experiment. Note that unlike \code{auto_log_output}, if this option is on then
these messages will not be shown in the console and instead they will only be logged
to the Comet experiment. This option is set to \code{FALSE} by default because of this
behavior.}

\item{\code{dynamic}}{If \code{TRUE} the Experiment was created rather than retrieved.}

\item{\code{workspace_name}}{The workspace name (can also be specified using the \code{COMET_WORKSPACE}
parameter as an environment variable or in a comet config file).}

\item{\code{project_name}}{The project name (can also be specified using the \code{COMET_PROJECT_NAME}
parameter as an environment variable or in a comet config file).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_key"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_key}{}}}
\subsection{Method \code{get_key()}}{
Get the experiment key of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_key()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_workspace_name"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_workspace_name}{}}}
\subsection{Method \code{get_workspace_name()}}{
Get the workspace name of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_workspace_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_project_name"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_project_name}{}}}
\subsection{Method \code{get_project_name()}}{
Get the project name of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_project_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_dynamic"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_dynamic}{}}}
\subsection{Method \code{get_dynamic()}}{
Get the dynamic status of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_dynamic()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_url"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_url}{}}}
\subsection{Method \code{get_url()}}{
Get the URL to view an experiment in the browser.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Get an experiment's metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_metadata()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-archive"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-archive}{}}}
\subsection{Method \code{archive()}}{
Archive an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$archive()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-restore"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-restore}{}}}
\subsection{Method \code{restore()}}{
Restore an archived experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$restore()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-delete}{}}}
\subsection{Method \code{delete()}}{
Delete an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-stop}{}}}
\subsection{Method \code{stop()}}{
Stop an experiment. Always call this method before creating a new experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_metric"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_metric}{}}}
\subsection{Method \code{log_metric()}}{
Log a metric name and value. Metrics are the only items that are logged as
a full time series. However, even metrics can be throttled if too much data
(either by rate or by count) is attempted to be logged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_metric(name, value, step = NULL, epoch = NULL, context = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(Required) Name of the metric.}

\item{\code{value}}{(Required) Value of the metric.}

\item{\code{step}}{Step number.}

\item{\code{epoch}}{Epoch.}

\item{\code{context}}{Context.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_metric"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_metric}{}}}
\subsection{Method \code{get_metric()}}{
Get All Metrics For Name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_metric(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(Required) Name of metric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_metrics_summary"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_metrics_summary}{}}}
\subsection{Method \code{get_metrics_summary()}}{
Get an experiment's metrics summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_metrics_summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_graph"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_graph}{}}}
\subsection{Method \code{log_graph()}}{
Log an experiment's associated model graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_graph(graph)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graph}}{(Required) JSON representation of a graph.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_graph"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_graph}{}}}
\subsection{Method \code{get_graph()}}{
Get an experiment's model graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_graph()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_parameter}{}}}
\subsection{Method \code{log_parameter()}}{
Log a parameter name and value. Note that you can only retrieve parameters
summary data (e.g., this is not recorded as a full time series).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_parameter(name, value, step = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(Required) Name of the parameter.}

\item{\code{value}}{(Required) Value of the parameter.}

\item{\code{step}}{Step number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_parameters}{}}}
\subsection{Method \code{get_parameters()}}{
Get an experiment's parameters summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_parameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_other"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_other}{}}}
\subsection{Method \code{log_other()}}{
Log a key/value `other`` data (not a metric or parameter). Note
that you can only retrieve others summary data (e.g., this is
not recorded as a full time series).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_other(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(Required) The key.}

\item{\code{value}}{(Required) The value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_other"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_other}{}}}
\subsection{Method \code{get_other()}}{
Get an experiment's others (logged with \code{log_other()}) summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_other()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-add_tags"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-add_tags}{}}}
\subsection{Method \code{add_tags()}}{
Add a list of tags to an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$add_tags(tags)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tags}}{(Required) List of tags.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_tags"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_tags}{}}}
\subsection{Method \code{get_tags()}}{
Get an experiment's tags.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_tags()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_html"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_html}{}}}
\subsection{Method \code{log_html()}}{
Set (or append onto) an experiment's HTML.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_html(html, override = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{html}}{(Required) An HTML string to add to the experiment.}

\item{\code{override}}{If \code{TRUE}, override the previous HTML. If \code{FALSE}, append to it.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_html"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_html}{}}}
\subsection{Method \code{get_html()}}{
Get an experiment's HTML.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_html()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-upload_asset"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-upload_asset}{}}}
\subsection{Method \code{upload_asset()}}{
Upload a file to the experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$upload_asset(
  file,
  step = NULL,
  overwrite = NULL,
  context = NULL,
  type = NULL,
  name = NULL,
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(Required) Path to the file to upload.}

\item{\code{step}}{Step number.}

\item{\code{overwrite}}{If \code{TRUE}, overwrite any uploaded file with the same name.}

\item{\code{context}}{The context.}

\item{\code{type}}{The type of asset.}

\item{\code{name}}{Name of the file on comet. By default the name of the file will
match the file that you upload, but you can use this parameter to use a
different name.}

\item{\code{metadata}}{Metadata to upload along with the file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_remote_asset"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_remote_asset}{}}}
\subsection{Method \code{log_remote_asset()}}{
Logs a Remote Asset identified by an URI. A Remote Asset is an asset but its content is not
uploaded and stored on Comet. Rather a link for its location is stored, so you can identify
and distinguish between two experiment using different version of a dataset stored somewhere
else.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_remote_asset(
  uri,
  remote_file_name = NULL,
  step = NULL,
  overwrite = FALSE,
  type = "asset",
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{(Required) The remote asset location, there is no imposed format, and it could be a
private link.}

\item{\code{remote_file_name}}{The "name" of the remote asset, could be a dataset
name, a model file name.}

\item{\code{step}}{Step number.}

\item{\code{overwrite}}{If \code{TRUE}, overwrite any logged asset with the same name.}

\item{\code{type}}{The type of asset, default: "asset".}

\item{\code{metadata}}{Metadata to log along with the asset}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_asset_list"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_asset_list}{}}}
\subsection{Method \code{get_asset_list()}}{
Get an experiment's asset list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_asset_list(type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type of assets to retrieve (by default, all assets are returned).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_asset"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_asset}{}}}
\subsection{Method \code{get_asset()}}{
Get an asset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_asset(assetId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{assetId}}{(Required) The asset ID to retrieve.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-create_symlink"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-create_symlink}{}}}
\subsection{Method \code{create_symlink()}}{
Add a symlink to an experiment in another project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$create_symlink(project_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project_name}}{(Required) Project that the experiment to should linked to.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_git_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_git_metadata}{}}}
\subsection{Method \code{log_git_metadata()}}{
Log an experiment's git metadata. This should only be called once and it can be done
automatically by enabling \code{log_git_info} in \code{\link[=create_experiment]{create_experiment()}} or \code{\link[=get_experiment]{get_experiment()}}.
This will replace any previous git metadata that was logged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_git_metadata(
  branch = NULL,
  origin = NULL,
  parent = NULL,
  user = NULL,
  root = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{branch}}{Git branch name.}

\item{\code{origin}}{Git repository origin.}

\item{\code{parent}}{Git commit SHA.}

\item{\code{user}}{Git username.}

\item{\code{root}}{Git root.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_git_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_git_metadata}{}}}
\subsection{Method \code{get_git_metadata()}}{
Get the git metadata of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_git_metadata()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_git_patch"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_git_patch}{}}}
\subsection{Method \code{get_git_patch()}}{
Get the git patch of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_git_patch()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_output"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_output}{}}}
\subsection{Method \code{get_output()}}{
Get an experiment's standard output and error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_output()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_code"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_code}{}}}
\subsection{Method \code{log_code()}}{
Log an experiment's source code. This should only be called once and it can be done
automatically by enabling \code{log_code} in \code{\link[=create_experiment]{create_experiment()}} or \code{\link[=get_experiment]{get_experiment()}}.
This will replace any previous code that was logged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_code(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{The code to set as the source code.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_code"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_code}{}}}
\subsection{Method \code{get_code()}}{
Get an experiment's source code.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_code()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_system_details"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_system_details}{}}}
\subsection{Method \code{log_system_details()}}{
Log system details. This can be done automatically by enabling \code{log_system_details}
in \code{\link[=create_experiment]{create_experiment()}} or \code{\link[=get_experiment]{get_experiment()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_system_details(
  command = NULL,
  executable = NULL,
  hostname = NULL,
  installed_packages = NULL,
  gpu_static_info = NULL,
  ip = NULL,
  network_interface_ips = NULL,
  additional_system_info = NULL,
  os = NULL,
  os_packages = NULL,
  os_type = NULL,
  pid = NULL,
  user = NULL,
  r_version = NULL,
  r_version_verbose = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Script and optional arguments.}

\item{\code{executable}}{Executable.}

\item{\code{hostname}}{Hostname.}

\item{\code{installed_packages}}{List of installed R packages.}

\item{\code{gpu_static_info}}{List of GPU information, where each GPU is a \code{list()} with
fields \code{gpuIndex}, \code{name}, \code{powerLimit}, \code{totalMemory}, \code{uuid}.}

\item{\code{ip}}{IP address.}

\item{\code{network_interface_ips}}{List of network interface IPs.}

\item{\code{additional_system_info}}{List of additional parameters to log,
where each parameter is a \code{list()} with \code{key} and \code{value} pairs.}

\item{\code{os}}{Full details about operating system.}

\item{\code{os_packages}}{List of operating system packages installed.}

\item{\code{os_type}}{Operating system type.}

\item{\code{pid}}{Process ID.}

\item{\code{user}}{User.}

\item{\code{r_version}}{Short form R version.}

\item{\code{r_version_verbose}}{Long form R version.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_system_details"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_system_details}{}}}
\subsection{Method \code{get_system_details()}}{
Get an experiment's system details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_system_details()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-log_artifact"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-log_artifact}{}}}
\subsection{Method \code{log_artifact()}}{
Log an \code{\link{Artifact}} object, synchronously create a new Artifact Version and
upload all local and remote assets attached to the \code{\link{Artifact}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_artifact(artifact)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{artifact}}{an \code{\link{Artifact}} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-get_artifact"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-get_artifact}{}}}
\subsection{Method \code{get_artifact()}}{
Returns a logged artifact object that can be used to access the artifact
version assets and download them locally.

If no version or alias is provided, the latest version for that artifact is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_artifact(
  artifact_name,
  workspace = NULL,
  version_or_alias = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{artifact_name}}{(Required) Retrieve an artifact with that name. This could either be a fully
qualified artifact name like \code{workspace/artifact-name:versionOrAlias} or just the name
of the artifact like \code{artifact-name}.}

\item{\code{workspace}}{Retrieve an artifact belonging to that workspace.}

\item{\code{version_or_alias}}{Retrieve the artifact by the given alias or version.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables define
exp <- create_experiment()

# Get a Comet Artifact
logged_artifact <- exp$get_artifact("workspace/artifact-name:version_or_alias")

# Which is equivalent to
logged_artifact = exp$get_artifact(artifact_name="artifact-name",
                                   workspace="workspace",
                                   version_or_alias="version_or_alias")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-set_start_end_time"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-set_start_end_time}{}}}
\subsection{Method \code{set_start_end_time()}}{
Set an experiment's start and end time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$set_start_end_time(start = NULL, end = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start}}{Start time for the experiment (milliseconds since the Epoch)}

\item{\code{end}}{End time for the experiment (milliseconds since the Epoch)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Experiment-print"></a>}}
\if{latex}{\out{\hypertarget{method-Experiment-print}{}}}
\subsection{Method \code{print()}}{
Print the experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$print()}\if{html}{\out{</div>}}
}

}
}
