% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hype_par_ordered.R
\name{R6_par_ordered}
\alias{R6_par_ordered}
\title{R6 class for hyperparameter of discrete (factor) variable}
\description{
R6 class for hyperparameter of discrete (factor) variable

R6 class for hyperparameter of discrete (factor) variable
}
\examples{
p1 <- par_ordered('x1', c('a', 'b', 'c'))
class(p1)
print(p1)
}
\section{Super class}{
\code{comparer::par_hype} -> \code{par_ordered}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Name of the parameter, must match the input to `eval_func`.}

\item{\code{values}}{Vector of values}

\item{\code{ggtrans}}{Transformation for ggplot, see ggplot2::scale_x_continuous()}

\item{\code{lower}}{Lower bound of the parameter}

\item{\code{upper}}{Upper bound of the parameter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-par_ordered-fromraw}{\code{R6_par_ordered$fromraw()}}
\item \href{#method-par_ordered-toraw}{\code{R6_par_ordered$toraw()}}
\item \href{#method-par_ordered-fromint}{\code{R6_par_ordered$fromint()}}
\item \href{#method-par_ordered-toint}{\code{R6_par_ordered$toint()}}
\item \href{#method-par_ordered-generate}{\code{R6_par_ordered$generate()}}
\item \href{#method-par_ordered-getseq}{\code{R6_par_ordered$getseq()}}
\item \href{#method-par_ordered-isvalid}{\code{R6_par_ordered$isvalid()}}
\item \href{#method-par_ordered-convert_to_mopar}{\code{R6_par_ordered$convert_to_mopar()}}
\item \href{#method-par_ordered-new}{\code{R6_par_ordered$new()}}
\item \href{#method-par_ordered-print}{\code{R6_par_ordered$print()}}
\item \href{#method-par_ordered-clone}{\code{R6_par_ordered$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-fromraw"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-fromraw}{}}}
\subsection{Method \code{fromraw()}}{
Function to convert from raw scale to transformed scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$fromraw(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value of raw scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-toraw"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-toraw}{}}}
\subsection{Method \code{toraw()}}{
Function to convert from transformed scale to raw scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$toraw(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value of transformed scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-fromint"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-fromint}{}}}
\subsection{Method \code{fromint()}}{
Convert from integer index to actual value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$fromint(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Integer index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-toint"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-toint}{}}}
\subsection{Method \code{toint()}}{
Convert from value to integer index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$toint(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-generate"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-generate}{}}}
\subsection{Method \code{generate()}}{
Generate values in the raw space based on quantiles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$generate(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{In [0,1].}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-getseq"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-getseq}{}}}
\subsection{Method \code{getseq()}}{
Get a sequence, uniform on the transformed scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$getseq(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of points. Ignored for discrete.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-isvalid"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-isvalid}{}}}
\subsection{Method \code{isvalid()}}{
Check if input is valid for parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$isvalid(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Parameter value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-convert_to_mopar"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-convert_to_mopar}{}}}
\subsection{Method \code{convert_to_mopar()}}{
Convert this to a parameter for the
mixopt R package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$convert_to_mopar(raw_scale = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw_scale}}{Should it be on the raw scale?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-new"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-new}{}}}
\subsection{Method \code{new()}}{
Create a hyperparameter with uniform distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$new(name, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the parameter, must match the input to `eval_func`.}

\item{\code{values}}{The values the variable can take on.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-print"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-print}{}}}
\subsection{Method \code{print()}}{
Print details of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_ordered-clone"></a>}}
\if{latex}{\out{\hypertarget{method-par_ordered-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_ordered$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
