% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comperank-package.R
\docType{package}
\name{comperank-package}
\alias{comperank}
\alias{comperank-package}
\title{comperank: Ranking and Rating Methods for Competition Results}
\description{
\code{comperank} provides tools for computing ranking and rating based on
competition results. It is tightly connected to its data infrastructure
package \link[comperes:comperes-package]{comperes}. Basic knowledge about
creating valid competition results and Head-to-Head expressions with
\code{comperes} is needed in order to efficiently use \code{comperank}.
}
\details{
\code{comperank} leverages the \href{https://www.tidyverse.org/}{tidyverse} ecosystem
of R packages. Among other things, it means that the main output format is
\link[tibble:tibble]{tibble}.

\code{comperank} gets inspiration from the book \href{https://www.amazon.com/Whos-1-Science-Rating-Ranking/dp/069116231X}{"Who's#1"} by
Langville and Meyer. It provides functionality for the following rating
algorithms:
\itemize{
\item Algorithms with \strong{fixed Head-to-Head structure}:
\itemize{
\item Simplified Massey method with \code{\link[=rate_massey]{rate_massey()}} and \code{\link[=rank_massey]{rank_massey()}}.
\item Simplified Colley method with \code{\link[=rate_colley]{rate_colley()}} and \code{\link[=rank_colley]{rank_colley()}}.
}
\item Algorithms with \strong{variable Head-to-Head structure}:
\itemize{
\item Keener method with \code{\link[=rate_keener]{rate_keener()}} and \code{\link[=rank_keener]{rank_keener()}}.
\item Markov method with \code{\link[=rate_markov]{rate_markov()}} and \code{\link[=rank_markov]{rank_markov()}}.
\item Offense-Defense method with \code{\link[=rate_od]{rate_od()}} and \code{\link[=rank_od]{rank_od()}}.
}
\item Algorithms with \strong{iterative nature}:
\itemize{
\item General Iterative ratings with \code{\link[=rate_iterative]{rate_iterative()}}, \code{\link[=rank_iterative]{rank_iterative()}},
and \code{\link[=add_iterative_ratings]{add_iterative_ratings()}}.
\item Elo ratings with \code{\link[=rate_elo]{rate_elo()}}, \code{\link[=rank_elo]{rank_elo()}}, and \code{\link[=add_elo_ratings]{add_elo_ratings()}}.
}
}

\code{comperank} also offers data sets describing professional snooker in seasons
2016/2017 and 2017/2018. See \link{snooker_events}, \link{snooker_players},
\link{snooker_matches}.

To learn more about \code{comperank} browse vignettes with browseVignettes(package
= "comperank").
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/echasnovski/comperank}
  \item Report bugs at \url{https://github.com/echasnovski/comperank/issues}
}

}
\author{
\strong{Maintainer}: Evgeni Chasnovski \email{evgeni.chasnovski@gmail.com}

}
