% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decomposed.R
\name{plot_decomposed_all}
\alias{plot_decomposed_all}
\title{Plot all decomposed time series from comp_tsout_ens or mv_tsout_ens output.}
\usage{
plot_decomposed_all(obj, X = NULL)
}
\arguments{
\item{obj}{The output from \code{comp_tsout_ens} or \code{mv_tsout_ens} functions.}

\item{X}{The data matrix used as input to \code{mv_tsout_ens} (not needed if \code{obj} is output from \code{comp_tsout_ens}).}
}
\value{
A ggplot showing the time series with facets by decomposition method.
}
\description{
Plot all decomposed time series from comp_tsout_ens or mv_tsout_ens output.
}
\examples{
\donttest{
set.seed(100)
n <- 600
x <- sample(1:100, n, replace=TRUE)
x[25] <- 200
x[320] <- 300
x2 <- sample(1:100, n, replace=TRUE)
x3 <- sample(1:100, n, replace=TRUE)
x4 <- sample(1:100, n, replace=TRUE)
X <- cbind.data.frame(x, x2, x3, x4)
out <- mv_tsout_ens(X, m1=c(1,2,4), compr=2)
plot_decomposed_all(out, X=X)
}
}
