% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPvalue.R
\name{getPValue}
\alias{getPValue}
\title{Calculate P-Value from a Sorted Distribution}
\usage{
getPValue(x, sorted_Distri)
}
\arguments{
\item{x}{A numeric value for which the P-value is to be calculated.}

\item{sorted_Distri}{A numeric vector representing a sorted distribution. This distribution must be sorted in ascending order.}
}
\value{
A numeric value indicating the P-value, representing the proportion of values in `sorted_Distri`
that are greater than or equal to `x`.
}
\description{
Computes the P-value for a given numeric value `x` based on its position within a sorted distribution.
This function utilizes a binary search approach for efficient computation.
}
\examples{
x <- rnorm(1)
sorted_dist <- sort(rnorm(100))
getPValue(x, sorted_dist)

}
