#' Example dataset used in a \code{conStruct} analysis
#' 
#' A simulated dataset containing the allele frequency 
#' and sampling coordinate data necessary to run a 
#' \code{conStruct} analysis.
#' 
#' @format A list with two elements:
#' \describe{
#'		\item{allele.frequencies}{a matrix with one row for each of 
#'			the 16 samples and one column for each of 10,000 loci, 
#'			giving the frequency of the counted allele at each locus 
#'			in each sample}
#'		\item{coords}{a matrix with one row for each of the 16 samples, 
#'			in the same order as that of the allele frequency matrix, 
#'			and two columns, the first giving the x-coordinate 
#'			(or longitude), the second giving the y-coordinate (or latitude)}
#' }
#
"conStruct.data"

#' Example \code{data.block} generated by a \code{conStruct} analysis
#' 
#' An example \code{data.block} object generated in a \code{conStruct} 
#' analysis from the raw data supplied by the user. This object is 
#' automatically saved and is used in several subsequent plotting functions.
#' 
#' @format A list with 7 elements:
#' \describe{
#'		\item{\code{N}}{the number of samples included in the analysis}
#'		\item{\code{K}}{the number of clusters/layers included in the model}
#'		\item{\code{spatial}}{a boolean indicating whether the spatial
#'			model has been specified}
#'		\item{\code{L}}{the number of loci included in the analysis}
#'		\item{\code{coords}}{a matrix with one row for each of the \code{N} samples, 
#'			in the same order as that of the \code{obsCov} matrix, 
#'			and two columns, the first giving the x-coordinate 
#'			(or longitude), the second giving the y-coordinate (or latitude)}
#'		\item{\code{obsCov}}{the sample allelic covariance matrix, 
#'			in the same order as that of the \code{coords} matrix, 
#'			with \code{N} rows and columns}
#'		\item{\code{geoDist}}{a matrix of pairwise geographic distance between , 
#'			samples in the same order as that of the \code{obsCov}, 
#'			with \code{N} rows and columns}
#'		\item{\code{sd.geoDist}}{the standard deviation of the raw geographic 
#'			distance matrix, used for normalizing \code{geoDist} within the 
#'			stan model}
#'		\item{\code{varMeanFreqs}}{the variance of the mean allele frequencies, 
#'			averaged over choice of counted allele (passed to the model 
#'			as a prior on the global covariance parameter)}
#' }
#
"data.block"