types = c("message", "warning", "error")
funs = c("message", "warning", "stop")

conditions = c(
  "assertion",
  "deprecated",
  "dimension",
  "future",
  "index",
  "io",
  "length",
  "library",
  "lookup",
  "missing",
  "name",
  "runtime",
  "type",
  "value"
)

template = ("
#' @rdname condition
#' @export
%3$s_%2$s = function(message, call = sys.call(-1L), attach = NULL) {
  %1$s(.Call(condition_%2$s_, \"%3$s\", message, call, attach))
}

#' @rdname as_condition
#' @export
as_%3$s_%2$s = function(message = NULL) {
  as_%2$s(\"%3$s\", message)
}
")

lines = character(0L)
con = textConnection("lines", open = "wt")
cat("### This file is automatically generated.", "### See [conditions]/inst/autogen/autogen.R.", "", sep = "\n", file = con)
cat(sprintf("#' @useDynLib conditions condition_%s_", types), sep = "\n", file = con)

Map(function(fun, type) {
  for (cond in conditions) {
    cat(sprintf(template, fun, type, cond), "\n", sep = "", file = con)
  }
}, fun = funs, type = types)
close(con)

path = devtools::as.package(".")$path
writeLines(head(lines, -1), file.path(path, "R", "autogenerated.R"))
