% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse.extra}
\alias{parse.extra}
\title{Parse the configuration {{var}} format, and replace it by extra.list values}
\usage{
parse.extra(config, extra.list = list(), other.config = "",
  rcmd.parse = FALSE, bash.parse = FALSE)
}
\arguments{
\item{config}{A list that were generated by read.config/eval.config/eval.config.merge}

\item{extra.list}{A list that can replace the configuration file '{{debug}}' by list(debug = TRUE), and {{debug}} will be setted to TRUE}

\item{other.config}{Path of another configuration file that can replace the configuration file '{{key:value}}'}

\item{rcmd.parse}{Logical wheather parse '@>@str_replace('abc', 'b', 'c')@<@' in config to 'acc'}

\item{bash.parse}{Logical wheather parse '#>#echo $HOME#<#' in config to your HOME PATH}
}
\value{
A list
}
\description{
Parse the configuration {{var}} format, and replace it by extra.list values
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config.other <- system.file('extdata', 'config.other.yaml', package='configr')
config <- read.config(config.json)
parse.extra(config, list(debug = 'TRUE'))
parse.extra(config, list(debug = 'TRUE'), other.config = config.other)
parse.extra(config, list(debug = 'TRUE'), other.config = config.other, 
rcmd.parse = TRUE)
parse.extra(config, list(debug = 'TRUE'), other.config = config.other, 
rcmd.parse = TRUE, bash.parse = TRUE)
}
